---
generated_at: 2026-01-27 12:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：25-WebAudioサンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **iOS での HTMLMediaElement 必須性**：デバイス・ブラウザバージョンによる

## 2) 参照した情報（Evidence一覧）

- E-01: `examples/webaudio_visualizer.html` (ビジュアライザーサンプル)
- E-02: `examples/files.json` (サンプルファイル一覧)
- E-03: `src/audio/Audio.js` (Audio クラス)
- E-04: `src/audio/AudioListener.js` (AudioListener クラス)
- E-05: `src/audio/AudioAnalyser.js` (AudioAnalyser クラス)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebAudioサンプルは4件 | E-02 (files.json の "webaudio" 配列) | ○ |
| C-02 | Audio が主機能 | E-06 (画面No 25 の関連機能) | ○ |
| C-03 | AudioListener が主機能 | E-06 (画面No 25 の関連機能) | ○ |
| C-04 | PositionalAudio が補助機能 | E-06 (画面No 25 の関連機能) | ○ |
| C-05 | AudioAnalyser が補助機能 | E-06 (画面No 25 の関連機能) | ○ |
| C-06 | Play ボタンで再生開始 | E-01 (Line 45-47, 69-70) | ○ |
| C-07 | AudioListener をカメラに追加 | E-01 (Line 91-93) | ○ |
| C-08 | AudioLoader でファイル読み込み | E-01 (Line 98-104) | ○ |
| C-09 | setBuffer() でバッファ設定 | E-01 (Line 101) | ○ |
| C-10 | play() で再生開始 | E-01 (Line 102) | ○ |
| C-11 | AudioAnalyser で周波数データ取得 | E-01 (Line 115, 160) | ○ |
| C-12 | fftSize: 128 | E-01 (Line 74, 115) | ○ |
| C-13 | DataTexture で周波数データをシェーダーに渡す | E-01 (Line 119-121) | ○ |
| C-14 | needsUpdate = true で更新 | E-01 (Line 162) | ○ |
| C-15 | ShaderMaterial でカスタムシェーダー | E-01 (Line 125-131) | ○ |
| C-16 | iOS 判定コードが存在 | E-01 (Line 96) | ○ |
| C-17 | setMediaElementSource() を iOS で使用 | E-01 (Line 108-111) | ○ |
| C-18 | フラグメントシェーダーで周波数を可視化 | E-01 (Line 23-39) | ○ |
| C-19 | texture2D で tAudioData をサンプリング | E-01 (Line 33) | ○ |
| C-20 | iOS での HTMLMediaElement 必須性 | **根拠不足** (デバイス・ブラウザ依存) | △ |

## 4) 不足情報（Unknown / Missing）
- **iOS の AudioContext 制限**：iOS のバージョンやブラウザによって挙動が異なる可能性
  - 候補：Apple 公式ドキュメント、実機テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Audio/AudioListener/AudioAnalyser の基本的な使用方法
- 0: 低リスク - シェーダーによるビジュアライゼーション
- 1: 中リスク - iOS 対応の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] 4つのサンプル (orientation, sandbox, timing, visualizer) の存在を確認
- [ ] iOS 実機でのオーディオ再生動作を確認
- [ ] Autoplay policy への対応が適切か確認
