---
generated_at: 2026-01-27 12:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：26-WebXRサンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **サンプル件数（約26件）**：files.json から計算した値
  2. **デバイス互換性**：VR/AR デバイスごとの対応状況

## 2) 参照した情報（Evidence一覧）

- E-01: `examples/webxr_ar_hittest.html` (AR ヒットテストサンプル)
- E-02: `examples/files.json` (サンプルファイル一覧)
- E-03: `examples/jsm/webxr/ARButton.js` (AR ボタン)
- E-04: `examples/jsm/webxr/VRButton.js` (VR ボタン)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebXRサンプルは約26件 | E-02 (files.json の "webxr" 配列) | ○ |
| C-02 | WebXRController が主機能 | E-05 (画面No 26 の関連機能) | ○ |
| C-03 | XRManager が主機能 | E-05 (画面No 26 の関連機能) | ○ |
| C-04 | StereoCamera が補助機能 | E-05 (画面No 26 の関連機能) | ○ |
| C-05 | ARButton.createButton() でボタン作成 | E-01 (Line 64), E-03 | ○ |
| C-06 | requiredFeatures: ['hit-test'] を指定 | E-01 (Line 64) | ○ |
| C-07 | renderer.xr.enabled = true で XR 有効化 | E-01 (Line 59) | ○ |
| C-08 | renderer.xr.getController() でコントローラー取得 | E-01 (Line 84) | ○ |
| C-09 | 'select' イベントでトリガー検出 | E-01 (Line 85) | ○ |
| C-10 | session.requestReferenceSpace('viewer') | E-01 (Line 126) | ○ |
| C-11 | session.requestHitTestSource() | E-01 (Line 128) | ○ |
| C-12 | frame.getHitTestResults() | E-01 (Line 149) | ○ |
| C-13 | hit.getPose() で位置取得 | E-01 (Line 156) | ○ |
| C-14 | reticle.matrix.fromArray() で位置設定 | E-01 (Line 156) | ○ |
| C-15 | レティクルで視覚フィードバック | E-01 (Line 92-98, 155-161) | ○ |
| C-16 | HemisphereLight でライティング | E-01 (Line 49-51) | ○ |
| C-17 | CylinderGeometry でオブジェクト作成 | E-01 (Line 68) | ○ |
| C-18 | iframe に allow="xr-spatial-tracking" | E-02 (examples/index.html Line 41) | ○ |
| C-19 | HTTPS または localhost が必要 | WebXR 仕様 (外部情報) | ○ |
| C-20 | XRFrame が animate コールバックに渡される | E-01 (Line 117, 119) | ○ |
| C-21 | 約26件の正確な件数 | **根拠不足** (files.json は動的に変更可能) | △ |
| C-22 | デバイス互換性 (Quest, VIVE等) | **根拠不足** (外部情報、変化する可能性) | △ |

## 4) 不足情報（Unknown / Missing）
- **件数の厳密性**：files.json の "webxr" 配列から計算
- **デバイス互換性**：VR/AR デバイスごとの動作確認は外部情報に依存
  - 候補：three.js 公式ドキュメント、WebXR Device API 仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ARButton/VRButton の基本的な使用方法
- 0: 低リスク - ヒットテストの基本パターン
- 1: 中リスク - サンプル件数の記述
- 1: 中リスク - デバイス互換性の記述

## 6) レビュアーチェックリスト（最小）
- [ ] files.json の "webxr" 配列件数が「約26件」と整合するか確認
- [ ] AR サンプルが ARCore/ARKit 対応デバイスで動作するか確認
- [ ] VR サンプルが主要 VR ヘッドセットで動作するか確認
