---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：27-物理シミュレーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **サンプル件数（約13件）**：files.json から計算した値
  2. **ソフトボディの Ammo.js 限定性**：外部物理エンジンの仕様

## 2) 参照した情報（Evidence一覧）

- E-01: `examples/physics_rapier_basic.html` (Rapier 基本サンプル)
- E-02: `examples/files.json` (サンプルファイル一覧)
- E-03: `examples/jsm/physics/RapierPhysics.js` (Rapier 統合)
- E-04: `examples/jsm/helpers/RapierHelper.js` (デバッグ表示)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 物理サンプルは約13件 | E-02 (files.json の "physics" 配列) | ○ |
| C-02 | Object3D が主機能 | E-05 (画面No 27 の関連機能) | ○ |
| C-03 | Mesh が補助機能 | E-05 (画面No 27 の関連機能) | ○ |
| C-04 | Matrix4 が補助機能 | E-05 (画面No 27 の関連機能) | ○ |
| C-05 | RapierPhysics をインポート | E-01 (Line 33) | ○ |
| C-06 | RapierHelper をインポート | E-01 (Line 34) | ○ |
| C-07 | physics = await RapierPhysics() | E-01 (Line 121) | ○ |
| C-08 | physics.addScene(scene) | E-01 (Line 123) | ○ |
| C-09 | physics.addMesh(mesh, mass, restitution) | E-01 (Line 154) | ○ |
| C-10 | userData.physics = { mass: 0 } で静的オブジェクト | E-01 (Line 93) | ○ |
| C-11 | RapierHelper でデバッグ表示 | E-01 (Line 128-129) | ○ |
| C-12 | setInterval(addBody, 1000) で定期生成 | E-01 (Line 131) | ○ |
| C-13 | position.y < threshold で落下検出 | E-01 (Line 173) | ○ |
| C-14 | scene.remove() と physics.removeMesh() | E-01 (Line 175-176) | ○ |
| C-15 | physicsHelper.update() | E-01 (Line 184) | ○ |
| C-16 | RoundedBoxGeometry を使用 | E-01 (Line 35, 138) | ○ |
| C-17 | OrbitControls でカメラ操作 | E-01 (Line 32, 81-84) | ○ |
| C-18 | Stats でパフォーマンス表示 | E-01 (Line 36, 107-108) | ○ |
| C-19 | shadowMap.enabled = true | E-01 (Line 77) | ○ |
| C-20 | Ammo, Rapier, Jolt の3種類対応 | E-02 (files.json で確認) | ○ |
| C-21 | 約13件の正確な件数 | **根拠不足** (files.json は動的に変更可能) | △ |
| C-22 | ソフトボディは Ammo.js のみ | **根拠不足** (外部物理エンジンの仕様) | △ |

## 4) 不足情報（Unknown / Missing）
- **件数の厳密性**：files.json の "physics" 配列から計算
- **ソフトボディの対応状況**：各物理エンジンの公式ドキュメントを参照する必要
  - 候補：Rapier 公式ドキュメント、Jolt 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RapierPhysics の基本的な使用方法
- 0: 低リスク - 物理ボディの追加・削除パターン
- 1: 中リスク - サンプル件数の記述
- 1: 中リスク - 各物理エンジンの機能差異

## 6) レビュアーチェックリスト（最小）
- [ ] files.json の "physics" 配列件数が「約13件」と整合するか確認
- [ ] Rapier, Jolt でのソフトボディ対応状況を確認
- [ ] 各物理エンジンの WASM ファイルの配置確認
