---
generated_at: 2026-01-27 12:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：28-CSS3Dサンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **サンプル件数（7件）**：files.json から計算した値

## 2) 参照した情報（Evidence一覧）

- E-01: `examples/css3d_periodictable.html` (元素周期表サンプル)
- E-02: `examples/files.json` (サンプルファイル一覧)
- E-03: `examples/jsm/renderers/CSS3DRenderer.js` (CSS3D レンダラー)
- E-04: `examples/jsm/libs/tween.module.js` (TWEEN ライブラリ)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSS3Dサンプルは7件 | E-02 (files.json の "css3d" 配列) | ○ |
| C-02 | Object3D が主機能 | E-05 (画面No 28 の関連機能) | ○ |
| C-03 | TWEEN, TrackballControls, CSS3DRenderer をインポート | E-01 (Line 107-109) | ○ |
| C-04 | PerspectiveCamera を作成 | E-01 (Line 243) | ○ |
| C-05 | Scene を作成 | E-01 (Line 246) | ○ |
| C-06 | document.createElement('div') で DOM 要素作成 | E-01 (Line 252) | ○ |
| C-07 | new CSS3DObject(element) でラップ | E-01 (Line 271) | ○ |
| C-08 | objectCSS.position で位置設定 | E-01 (Line 272-274) | ○ |
| C-09 | scene.add(objectCSS) | E-01 (Line 275) | ○ |
| C-10 | targets.table/sphere/helix/grid で目標位置 | E-01 (Line 236, 289-343) | ○ |
| C-11 | CSS3DRenderer().setSize() | E-01 (Line 347-348) | ○ |
| C-12 | TrackballControls を使用 | E-01 (Line 353) | ○ |
| C-13 | controls.addEventListener('change', render) | E-01 (Line 356) | ○ |
| C-14 | button.addEventListener で遷移 | E-01 (Line 358-384) | ○ |
| C-15 | transform() で TWEEN アニメーション | E-01 (Line 386, 394-420) | ○ |
| C-16 | TWEEN.Tween(position).to().easing().start() | E-01 (Line 403-406) | ○ |
| C-17 | animate() で TWEEN.update() | E-01 (Line 437) | ○ |
| C-18 | requestAnimationFrame(animate) | E-01 (Line 435) | ○ |
| C-19 | renderer.render(scene, camera) | E-01 (Line 445) | ○ |
| C-20 | 7件の正確な件数 | **根拠不足** (files.json は動的に変更可能) | △ |

## 4) 不足情報（Unknown / Missing）
- **件数の厳密性**：files.json の "css3d" 配列から計算

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CSS3DRenderer の基本的な使用方法
- 0: 低リスク - CSS3DObject の配置方法
- 0: 低リスク - TWEEN アニメーションの使用方法

## 6) レビュアーチェックリスト（最小）
- [ ] files.json の "css3d" 配列件数が「7件」と整合するか確認
- [ ] 各サンプルの動作確認（periodictable, molecules, sprites, youtube, sandbox, orthographic, mixed）
