---
generated_at: 2026-01-27 12:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-CSS2Dサンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `examples/css2d_label.html` (CSS2D ラベルサンプル)
- E-02: `examples/files.json` (サンプルファイル一覧)
- E-03: `examples/jsm/renderers/CSS2DRenderer.js` (CSS2D レンダラー)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSS2Dサンプルは1件 | E-02 (files.json の "css2d" 配列: ["css2d_label"]) | ○ |
| C-02 | Object3D が主機能 | E-04 (画面No 29 の関連機能) | ○ |
| C-03 | CSS2DRenderer をインポート | E-01 (Line 34) | ○ |
| C-04 | CSS2DObject をインポート | E-01 (Line 34) | ○ |
| C-05 | camera.layers.enableAll() | E-01 (Line 84) | ○ |
| C-06 | earth.layers.enableAll() | E-01 (Line 123) | ○ |
| C-07 | document.createElement('div') でラベル作成 | E-01 (Line 126) | ○ |
| C-08 | div.className = 'label' | E-01 (Line 127) | ○ |
| C-09 | new CSS2DObject(earthDiv) | E-01 (Line 131) | ○ |
| C-10 | earthLabel.layers.set(0) | E-01 (Line 135) | ○ |
| C-11 | earthMassLabel.layers.set(1) | E-01 (Line 146) | ○ |
| C-12 | earth.add(earthLabel) | E-01 (Line 134) | ○ |
| C-13 | CSS2DRenderer() でレンダラー作成 | E-01 (Line 177) | ○ |
| C-14 | labelRenderer.domElement.style.position = 'absolute' | E-01 (Line 179) | ○ |
| C-15 | OrbitControls(camera, labelRenderer.domElement) | E-01 (Line 183) | ○ |
| C-16 | renderer.render(scene, camera) | E-01 (Line 218) | ○ |
| C-17 | labelRenderer.render(scene, camera) | E-01 (Line 219) | ○ |
| C-18 | GUI でレイヤー切り替え | E-01 (Line 225-236) | ○ |
| C-19 | camera.layers.toggle(0) | E-01 (Line 46) | ○ |
| C-20 | timer.update() と timer.getElapsed() | E-01 (Line 210, 214) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（CSS2D サンプルは1件のみで、完全にソースコードから検証可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CSS2DRenderer の基本的な使用方法
- 0: 低リスク - レイヤー機能の使用方法
- 0: 低リスク - 2つのレンダラーの連携

## 6) レビュアーチェックリスト（最小）
- [ ] css2d_label サンプルの動作確認
- [ ] レイヤー切り替え（Toggle Name / Toggle Mass）の動作確認
- [ ] 月の軌道アニメーションでラベルが追従することを確認
