---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-Sidebar - Scene

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠が確認された。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `editor/js/Sidebar.Scene.js` - SidebarSceneクラス定義、行1-593
- E-02: `editor/js/Editor.js` - Editorクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `editor/js/Viewport.js` - 背景・環境・霧の適用処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Sceneでシーングラフ階層表示 | E-01行132-149, E-03 | ○ |
| C-02 | Fogでリニアフォグ設定 | E-01行360-366, E-03 | ○ |
| C-03 | FogExp2で指数フォグ設定 | E-01行370, E-03 | ○ |
| C-04 | Colorで背景色設定 | E-01行174, E-03 | ○ |
| C-05 | Textureで背景テクスチャ設定 | E-01行177-179, E-03 | ○ |
| C-06 | nodeStatesでツリー状態管理 | E-01行17 | ○ |
| C-07 | outliner.onChange()で選択処理 | E-01行134-142 | ○ |
| C-08 | outliner.onDblClick()でフォーカス | E-01行143-147 | ○ |
| C-09 | buildOption()でDOM要素生成 | E-01行19-54 | ○ |
| C-10 | backgroundType選択UI | E-01行155-169 | ○ |
| C-11 | backgroundColor入力UI | E-01行174 | ○ |
| C-12 | backgroundTexture入力UI | E-01行177-179 | ○ |
| C-13 | backgroundEquirectangularTexture入力UI | E-01行181-183 | ○ |
| C-14 | backgroundColorSpace選択UI | E-01行189-198 | ○ |
| C-15 | backgroundBlurriness/Intensity/Rotation入力UI | E-01行207-214 | ○ |
| C-16 | environmentType選択UI | E-01行259-272 | ○ |
| C-17 | environmentEquirectangularTexture入力UI | E-01行277-279 | ○ |
| C-18 | fogType選択UI | E-01行328-340 | ○ |
| C-19 | fogColor/Near/Far/Density入力UI | E-01行354-371 | ○ |
| C-20 | onBackgroundChanged()でシグナル発火 | E-01行218-230 | ○ |
| C-21 | onEnvironmentChanged()でシグナル発火 | E-01行283-289 | ○ |
| C-22 | onFogChanged()/onFogSettingsChanged()でシグナル発火 | E-01行303-325 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Sidebar.Scene.jsの行番号参照が正確か確認
- [ ] 背景タイプの選択肢（Default/Color/Texture/Equirectangular）が正しいか確認
- [ ] 環境タイプの選択肢（Default/Equirectangular/None）が正しいか確認
- [ ] 霧タイプの選択肢（None/Fog/FogExp2）が正しいか確認
- [ ] 画面機能マッピングの関連機能が網羅されているか確認
