---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-その他サンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **エクスポート失敗時のエラーメッセージ仕様**：実装コードで確認が必要
  2. **サンプル総数17件の正確性**：ファイルシステム上は22件検出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/misc_controls_orbit.html` - OrbitControlsサンプル実装
- E-02: `examples/jsm/controls/OrbitControls.js` - OrbitControls実装
- E-03: `examples/misc_exporter_gltf.html` - GLTFエクスポーターサンプル
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: Globによるファイル検索結果 - misc_*.htmlファイル一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | その他サンプルは17種類のサンプルを提供 | E-06（22件検出） | △ |
| C-02 | OrbitControlsはマウスドラッグでカメラ軌道制御 | E-01, E-02 | ○ |
| C-03 | Import Mapを使用してthree.jsモジュールをインポート | E-01（25-32行目） | ○ |
| C-04 | lil-guiライブラリをGUIパネルに使用 | E-01（インポートなし）, E-03 | ○ |
| C-05 | 関連機能No.169はControls | E-05 | ○ |
| C-06 | サンプルは独立したHTMLファイルとして実装 | E-06 | ○ |
| C-07 | OrbitControlsはspherical座標を使用 | E-02 | ○ |
| C-08 | PointerLockControlsはFPS形式の制御 | E-04 | ○ |
| C-09 | GLTFExporterでシーンをGLTF形式でエクスポート | E-03 | ○ |
| C-10 | enableDampingオプションが存在 | E-01（67行目） | ○ |
| C-11 | animate関数でrequestAnimationLoop | E-01（54行目、setAnimationLoop使用） | ○ |
| C-12 | minDistance/maxDistanceでズーム制限 | E-01（72-73行目） | ○ |
| C-13 | maxPolarAngleでカメラ角度制限 | E-01（75行目） | ○ |
| C-14 | InstancedMeshを使用したシーン構築 | E-01（82行目） | ○ |
| C-15 | DirectionalLightで照明設定 | E-01（100-106行目） | ○ |
| C-16 | AmbientLightも使用 | E-01（108行目） | ○ |
| C-17 | FogExp2で霧効果 | E-01（49行目） | ○ |
| C-18 | エクスポート失敗時のエラーメッセージ表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- サンプル総数について：画面一覧.csvでは17件と記載があるが、ファイルシステム上は22件のmisc_*.htmlファイルが存在。これは画面一覧の定義と実際のファイル数の乖離が原因。
  - 候補：画面一覧.csvの更新 / 設計書の修正 / 複数サンプルを1エントリにカウント
- エクスポート失敗時のエラーハンドリング：具体的なエラーメッセージの実装は各エクスポーターサンプルの詳細確認が必要。

## 5) リスクフラグ（レビュー観点）
- 0: サンプル数の記載（17件 vs 22件）は文書との整合性確認要
- 1: エクスポーターのエラーハンドリング実装の確認要

## 6) レビュアーチェックリスト（最小）
- [ ] サンプル総数が正確か確認（17件 or 22件の整理）
- [ ] 各コントロールの操作方法が正確か実機確認
- [ ] エクスポーター系サンプルのエラーハンドリング実装確認
- [ ] Import Mapの記述が最新のthree.jsバージョンと整合しているか確認
