---
generated_at: 2026-01-27 12:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：32-ゲームサンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **collision-world.glbの存在確認**：ファイルパス要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/games_fps.html` - FPSゲームサンプル実装（499行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: Globによるファイル検索結果 - games_fps.htmlの存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FPSスタイルのインタラクティブデモ | E-01, E-02 | ○ |
| C-02 | Octreeを使用した衝突検出 | E-01（115行目、worldOctree） | ○ |
| C-03 | WASDキーでプレイヤー移動 | E-01（379-401行目） | ○ |
| C-04 | スペースキーでジャンプ | E-01（403-411行目） | ○ |
| C-05 | マウスクリックでボール投擲 | E-01（151-155行目、throwBall呼び出し） | ○ |
| C-06 | GRAVITY定数は30 | E-01（86行目） | ○ |
| C-07 | NUM_SPHERESは100 | E-01（88行目） | ○ |
| C-08 | STEPS_PER_FRAMEは5 | E-01（91行目） | ○ |
| C-09 | IcosahedronGeometryでボール生成 | E-01（93行目） | ○ |
| C-10 | Capsuleでプレイヤー衝突形状定義 | E-01（117行目） | ○ |
| C-11 | Y座標-25以下でテレポート | E-01（454-466行目） | ○ |
| C-12 | VSMShadowMap使用 | E-01（77行目） | ○ |
| C-13 | ACESFilmicToneMapping使用 | E-01（78行目） | ○ |
| C-14 | Timerで時間管理 | E-01（41-42行目） | ○ |
| C-15 | collision-world.glb読み込み | E-01（417行目） | ○ |
| C-16 | OctreeHelper表示切り替えGUI | E-01（444-450行目） | ○ |
| C-17 | HemisphereLight使用 | E-01（51-53行目） | ○ |
| C-18 | DirectionalLight使用 | E-01（55-68行目） | ○ |
| C-19 | Stats.js使用 | E-01（81-84行目） | ○ |
| C-20 | collision-world.glbファイルの存在 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- collision-world.glbファイルの存在確認：コード上では`./models/gltf/collision-world.glb`パスで参照されているが、実ファイルの存在は別途確認が必要。
  - 候補：ファイルシステム確認 / GLTFモデルの内容確認

## 5) リスクフラグ（レビュー観点）
- 0: ゲームロジックの実装は詳細に確認済み
- 1: 3Dモデルファイルの存在・形式の確認要

## 6) レビュアーチェックリスト（最小）
- [ ] collision-world.glbファイルの存在確認
- [ ] 物理演算パラメータ（GRAVITY、ジャンプ速度等）のゲームバランス確認
- [ ] ポインターロックの各ブラウザでの動作確認
- [ ] モバイルデバイスでの動作（タッチ操作対応）確認
