---
generated_at: 2026-01-27 12:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-テストサンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/webgl_furnace_test.html` - White Furnace Testサンプル実装（157行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: Google Filament Documentation - White Furnace Test理論

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 11x11のマテリアル球を表示 | E-01（90-111行目、for x,y 0-10） | ○ |
| C-02 | roughnessは横方向に増加 | E-01（95行目、roughness: x/10） | ○ |
| C-03 | metalnessは縦方向に増加 | E-01（96行目、metalness: y/10） | ○ |
| C-04 | MeshPhysicalMaterial使用 | E-01（94行目） | ○ |
| C-05 | 背景色はCOLOR定数（0xcccccc） | E-01（35行目） | ○ |
| C-06 | マウスオーバーで純白（0xffffff）に変更 | E-01（52-61行目） | ○ |
| C-07 | マウスアウトで0xccccff（ティント）に変更 | E-01（64-73行目） | ○ |
| C-08 | PMREMGeneratorで環境マップ生成 | E-01（120-121行目） | ○ |
| C-09 | SphereGeometry(0.4, 32, 16)で球体生成 | E-01（88行目） | ○ |
| C-10 | envMapIntensity = 1 | E-01（99行目） | ○ |
| C-11 | transmission = 0 | E-01（100行目） | ○ |
| C-12 | ior = 1.5 | E-01（101行目） | ○ |
| C-13 | カメラ位置z=18 | E-01（82行目） | ○ |
| C-14 | カメラFOV=40 | E-01（81行目） | ○ |
| C-15 | Promise chainによる初期化 | E-01（148-152行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 全ての実装詳細がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] White Furnace Testの理論的背景（Filamentドキュメント）との整合性確認
- [ ] エネルギー保存性の視覚的確認（純白環境で球が背景と同化するか）
- [ ] 各roughness/metalness組み合わせでの挙動確認
