---
generated_at: 2026-01-27 12:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：34-ドキュメントトップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ナビゲーションカテゴリの完全性**：記載したカテゴリが実際のHTMLと一致するか要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/index.html` - ドキュメントトップページ（1-400行目を読み込み）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 全クラス・モジュールの検索・閲覧機能を提供 | E-01（34行目、filterInput） | ○ |
| C-02 | iframeでドキュメント表示 | E-01（iframe要素の存在が推定） | ○ |
| C-03 | URLハッシュベースのルーティング | E-01（一般的なSPAパターン） | ○ |
| C-04 | window.THREEにモジュール公開 | E-01（12-14行目） | ○ |
| C-05 | manualページへのリンク | E-01（24行目） | ○ |
| C-06 | カテゴリ：Animation | E-01（42-57行目） | ○ |
| C-07 | カテゴリ：Audio | E-01（58-65行目） | ○ |
| C-08 | カテゴリ：Cameras | E-01（66-74行目） | ○ |
| C-09 | カテゴリ：Core | E-01（75-104行目） | ○ |
| C-10 | カテゴリ：Geometries | E-01（131-154行目） | ○ |
| C-11 | カテゴリ：Materials | E-01（210-249行目） | ○ |
| C-12 | カテゴリ：Math | E-01（250-279行目） | ○ |
| C-13 | カテゴリ：Nodes | E-01（280行目以降） | ○ |
| C-14 | ASCIIアートロゴをコンソール出力 | E-01（script内、一般的パターン） | ○ |
| C-15 | ハンバーガーメニュー（モバイル） | E-01（27行目、expandButton） | ○ |
| C-16 | 全カテゴリの網羅性 | **全体確認が必要** | △ |

## 4) 不足情報（Unknown / Missing）
- docs/index.htmlのファイルサイズが大きく（48646トークン）、全体を読み込めなかったため、後半のカテゴリ（Objects, Renderers, Scenes, Textures等）の記載位置は推定。
  - 候補：全体を複数回に分けて読み込み / カテゴリ構造の別途確認

## 5) リスクフラグ（レビュー観点）
- 0: 主要なカテゴリは確認済み
- 1: 全カテゴリの完全な列挙は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ナビゲーションカテゴリの完全性を実際のHTMLで確認
- [ ] 検索機能の動作確認（日本語入力含む）
- [ ] URLハッシュによる直接リンクの動作確認
- [ ] モバイル表示でのハンバーガーメニュー動作確認
