---
generated_at: 2026-01-27 12:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-Material Browser

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/scenes/material-browser.html` - Material Browserソースコード（819行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | lil-guiでパラメータ調整 | E-01（39行目、import GUI） | ○ |
| C-02 | MeshBasicMaterialサポート | E-01（606-614行目） | ○ |
| C-03 | MeshStandardMaterialサポート | E-01（667-681行目） | ○ |
| C-04 | MeshPhysicalMaterialサポート | E-01（683-697行目） | ○ |
| C-05 | TorusKnotGeometryで表示 | E-01（776行目） | ○ |
| C-06 | PMREMGeneratorで環境マップ | E-01（750行目） | ○ |
| C-07 | RoomEnvironment使用 | E-01（40行目、import） | ○ |
| C-08 | envMapsプリロード | E-01（123-144行目） | ○ |
| C-09 | diffuseMapsプリロード | E-01（146-158行目） | ○ |
| C-10 | roughnessMapsプリロード | E-01（160-172行目） | ○ |
| C-11 | matcapsプリロード | E-01（174-181行目） | ○ |
| C-12 | alphaMapsプリロード | E-01（183-195行目） | ○ |
| C-13 | gradientMapsプリロード | E-01（197-213行目） | ○ |
| C-14 | handleColorChange関数 | E-01（241-255行目） | ○ |
| C-15 | updateTexture関数 | E-01（282-291行目） | ○ |
| C-16 | guiSceneFog関数で霧設定 | E-01（308-337行目） | ○ |
| C-17 | generateVertexColors関数 | E-01（223-239行目） | ○ |
| C-18 | MeshMatcapMaterialでライトOFF | E-01（634-636行目） | ○ |
| C-19 | prevFogで霧変更検出 | E-01（785-798行目） | ○ |
| C-20 | デフォルトはMeshBasicMaterial | E-01（600行目、|| 'MeshBasicMaterial'） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 全ての実装詳細がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各マテリアルタイプの切り替えが正しく動作するか確認
- [ ] テクスチャ選択が正しく反映されるか確認
- [ ] PBRマテリアルの環境マップ表示確認
- [ ] 霧の切り替えでneedsUpdateが正しく設定されるか確認
