---
generated_at: 2026-01-27 12:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：39-スタンドアロンアプリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **APP.Playerクラスの実装詳細**：app.jsファイルが存在しないため確認困難
  2. **app.json構造の正確性**：実際のエクスポート結果での確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/js/libs/app/index.html` - スタンドアロンアプリテンプレート（59行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Import Mapでthreeとthree/webgpuをマッピング | E-01（21-27行目） | ○ |
| C-02 | import * as THREE from 'three' | E-01（31行目） | ○ |
| C-03 | import { APP } from './js/app.js' | E-01（32行目） | ○ |
| C-04 | window.THREE = THREE | E-01（34行目） | ○ |
| C-05 | new THREE.FileLoader() | E-01（36行目） | ○ |
| C-06 | loader.load('app.json', callback) | E-01（37行目） | ○ |
| C-07 | new APP.Player() | E-01（39行目） | ○ |
| C-08 | await player.load(JSON.parse(text)) | E-01（40行目） | ○ |
| C-09 | player.setSize() | E-01（41行目） | ○ |
| C-10 | player.play() | E-01（42行目） | ○ |
| C-11 | document.body.appendChild(player.dom) | E-01（44行目） | ○ |
| C-12 | resizeイベントリスナー | E-01（46-50行目） | ○ |
| C-13 | APP.Playerクラスの内部実装 | **app.jsファイル未確認** | △ |
| C-14 | app.json構造の詳細 | **エクスポート結果での確認が必要** | △ |

## 4) 不足情報（Unknown / Missing）
- `editor/js/libs/app/js/app.js`ファイルが存在しないか、テンプレートとしてエクスポート時に動的に生成される可能性がある。
  - 候補：editor/js/Player.jsを参照 / 実際のエクスポート処理を確認
- app.jsonの構造は推測に基づいており、実際のエクスポート結果で確認が必要。
  - 候補：エディタでエクスポートを実行して確認

## 5) リスクフラグ（レビュー観点）
- 1: APP.Playerの実装詳細が不明
- 1: app.json構造の正確性要確認

## 6) レビュアーチェックリスト（最小）
- [ ] エディタからの実際のエクスポートで動作確認
- [ ] app.jsの内容・生成方法の確認
- [ ] app.json構造の実際の出力確認
- [ ] WebGPUレンダラー使用時の動作確認
