---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-Sidebar - Object

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠が確認された。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `editor/js/Sidebar.Object.js` - SidebarObjectクラス定義、行1-899
- E-02: `editor/js/Editor.js` - Editorクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `editor/js/commands/SetPositionCommand.js` - 位置変更コマンド
- E-05: `editor/js/commands/SetRotationCommand.js` - 回転変更コマンド
- E-06: `editor/js/commands/SetScaleCommand.js` - スケール変更コマンド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Object3Dで位置・回転・スケール編集 | E-01行114-146, E-03 | ○ |
| C-02 | Vector3で3D位置・スケール編集 | E-01行442, E-03 | ○ |
| C-03 | Eulerで回転表示・編集 | E-01行449, E-03 | ○ |
| C-04 | オブジェクト未選択時に非表示 | E-01行25 | ○ |
| C-05 | objectType表示 | E-01行72-78 | ○ |
| C-06 | objectUUID表示・再生成 | E-01行82-96 | ○ |
| C-07 | objectName編集 | E-01行100-110 | ○ |
| C-08 | objectPosition X/Y/Z編集 | E-01行114-122 | ○ |
| C-09 | objectRotation X/Y/Z編集（度単位） | E-01行126-134 | ○ |
| C-10 | objectScale X/Y/Z編集 | E-01行138-146 | ○ |
| C-11 | カメラFOV/Near/Far編集 | E-01行150-216 | ○ |
| C-12 | ライトIntensity/Color編集 | E-01行218-246 | ○ |
| C-13 | シャドウCast/Receive設定 | E-01行290-300 | ○ |
| C-14 | シャドウIntensity/Bias/NormalBias/Radius設定 | E-01行304-344 | ○ |
| C-15 | visible/frustumCulled/renderOrder設定 | E-01行348-374 | ○ |
| C-16 | userData JSON編集 | E-01行378-401 | ○ |
| C-17 | JSONエクスポート機能 | E-01行405-428 | ○ |
| C-18 | SidebarObjectAnimation追加 | E-01行432 | ○ |
| C-19 | update()で値変更処理 | E-01行436-638 | ○ |
| C-20 | updateRows()で動的行表示 | E-01行640-696 | ○ |
| C-21 | updateUI()で値表示更新 | E-01行749-892 | ○ |
| C-22 | ライト選択時に回転・スケール行非表示 | E-01行698-712 | ○ |
| C-23 | 変更閾値0.01 | E-01行443, 450, 457 | ○ |
| C-24 | 回転はラジアン-度変換 | E-01行760-762 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Sidebar.Object.jsの行番号参照が正確か確認
- [ ] 各Commandクラスの実装が正しく参照されているか確認
- [ ] 動的行表示の条件（ライト、カメラ等）が正しいか確認
- [ ] 画面機能マッピングの関連機能が網羅されているか確認
