---
generated_at: 2026-01-27 12:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-ユニットテスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/unit/UnitTests.html` - ユニットテストランナーHTML（27行）
- E-02: `test/unit/three.source.unit.js` - テストインポート定義（294行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QUnitテストフレームワーク使用 | E-01（6行目、13行目、qunit.css/qunit.js読み込み） | ○ |
| C-02 | Import Mapでthreeをマッピング | E-01（15-21行目） | ○ |
| C-03 | three -> build/three.module.js | E-01（18行目） | ○ |
| C-04 | three.source.unit.jsをmoduleとしてインポート | E-01（24行目） | ○ |
| C-05 | console-wrapper.jsインポート | E-02（1行目） | ○ |
| C-06 | qunit-utils.jsインポート | E-02（2行目） | ○ |
| C-07 | constants.tests.jsインポート | E-02（5行目） | ○ |
| C-08 | animation関連テスト（8ファイル） | E-02（10-17行目） | ○ |
| C-09 | animation/tracks関連テスト（6ファイル） | E-02（20-25行目） | ○ |
| C-10 | audio関連テスト（5ファイル） | E-02（29-33行目） | ○ |
| C-11 | cameras関連テスト（6ファイル） | E-02（37-42行目） | ○ |
| C-12 | core関連テスト（15ファイル） | E-02（46-60行目） | ○ |
| C-13 | geometries関連テスト（21ファイル） | E-02（91-111行目） | ○ |
| C-14 | helpers関連テスト（13ファイル） | E-02（115-127行目） | ○ |
| C-15 | lights関連テスト（12ファイル） | E-02（131-142行目） | ○ |
| C-16 | materials関連テスト（19ファイル） | E-02（165-182行目） | ○ |
| C-17 | math関連テスト（23+4ファイル） | E-02（186-213行目） | ○ |
| C-18 | objects関連テスト（13ファイル） | E-02（217-229行目） | ○ |
| C-19 | renderers関連テスト（30ファイル） | E-02（233-266行目） | ○ |
| C-20 | textures関連テスト（12ファイル） | E-02（282-292行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 全ての実装詳細がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] npm install後にQUnitが正しく動作するか確認
- [ ] Import Mapがブラウザで正しく解決されるか確認
- [ ] テスト実行時にエラーが発生しないか確認
- [ ] 全テストスイートが正常に完了するか確認
