---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Sidebar - Geometry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠が確認された。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `editor/js/Sidebar.Geometry.js` - SidebarGeometryクラス定義、行1-412
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BufferGeometryでジオメトリ情報表示 | E-01行137, E-02 | ○ |
| C-02 | BoxGeometryパラメータ編集対応 | E-01行290, E-02 | ○ |
| C-03 | SphereGeometryパラメータ編集対応 | E-01行290, E-02 | ○ |
| C-04 | CylinderGeometryパラメータ編集対応 | E-01行290, E-02 | ○ |
| C-05 | TorusGeometryパラメータ編集対応 | E-01行290, E-02 | ○ |
| C-06 | PlaneGeometryパラメータ編集対応 | E-01行290, E-02 | ○ |
| C-07 | currentGeometryTypeで動的パネル管理 | E-01行23 | ○ |
| C-08 | geometryType表示 | E-01行90-96 | ○ |
| C-09 | geometryUUID表示・再生成 | E-01行100-114 | ○ |
| C-10 | geometryName編集 | E-01行118-128 | ○ |
| C-11 | parametersコンテナで動的読み込み | E-01行132-133 | ○ |
| C-12 | バウンディングボックス表示 | E-01行141-146, 300-307 | ○ |
| C-13 | 頂点法線ヘルパー表示 | E-01行197-218 | ○ |
| C-14 | geometryUserData編集 | E-01行150-193 | ○ |
| C-15 | JSONエクスポート機能 | E-01行222-245 | ○ |
| C-16 | モーフターゲット操作 | E-01行249-260, 329-348, 356-376 | ○ |
| C-17 | 動的import使用 | E-01行290 | ○ |
| C-18 | build関数でメイン構築 | E-01行263-352 | ○ |
| C-19 | geometryChangedシグナルで再構築 | E-01行404 | ○ |
| C-20 | objectSelectedシグナルで表示切替 | E-01行396-402 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Sidebar.Geometry.jsの行番号参照が正確か確認
- [ ] 動的importの対象ジオメトリタイプが網羅されているか確認
- [ ] モーフターゲット機能の動作条件が正しいか確認
- [ ] 画面機能マッピングの関連機能が網羅されているか確認
