---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Sidebar - Material

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠が確認された。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `editor/js/Sidebar.Material.js` - SidebarMaterialクラス定義、行1-752
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Materialでマテリアル編集 | E-01, E-02 | ○ |
| C-02 | MeshBasicMaterial対応 | E-01行692-730, E-02 | ○ |
| C-03 | MeshLambertMaterial対応 | E-01行692-730, E-02 | ○ |
| C-04 | MeshPhongMaterial対応 | E-01行692-730, E-02 | ○ |
| C-05 | MeshStandardMaterial対応 | E-01行692-730, E-02 | ○ |
| C-06 | MeshPhysicalMaterial対応 | E-01行692-730, E-02 | ○ |
| C-07 | Textureでマップ設定 | E-01行209-322, E-02 | ○ |
| C-08 | Colorで色設定 | E-01行91-107, E-02 | ○ |
| C-09 | currentObject/currentMaterialSlot管理 | E-01行21-24 | ○ |
| C-10 | マテリアルスロット選択 | E-01行32-40 | ○ |
| C-11 | マテリアルタイプ選択 | E-01行44-50 | ○ |
| C-12 | UUID表示・再生成 | E-01行54-68 | ○ |
| C-13 | Name編集 | E-01行72-82 | ○ |
| C-14 | SidebarMaterialProgram追加 | E-01行86-87 | ○ |
| C-15 | 各種プロパティUI群 | E-01行91-397 | ○ |
| C-16 | UserData編集 | E-01行401-423 | ○ |
| C-17 | JSONエクスポート | E-01行426-451 | ○ |
| C-18 | update関数で変更処理 | E-01行455-560 | ○ |
| C-19 | refreshUI関数で表示更新 | E-01行580-651 | ○ |
| C-20 | MeshPhysical切替時のプロパティコピー | E-01行489-517 | ○ |
| C-21 | materialClasses定義 | E-01行692-709 | ○ |
| C-22 | オブジェクトタイプ別オプション | E-01行717-749 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Sidebar.Material.jsの行番号参照が正確か確認
- [ ] 対応するマテリアルタイプが網羅されているか確認
- [ ] プロパティコンポーネントの一覧が正しいか確認
- [ ] 画面機能マッピングの関連機能が網羅されているか確認
