---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Sidebar - Script

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠が確認された。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `editor/js/Sidebar.Script.js` - SidebarScriptクラス定義、行1-130
- E-02: `editor/js/Editor.js` - scripts管理
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventDispatcherでイベント管理 | E-02, E-03 | ○ |
| C-02 | scriptsContainerでスクリプト一覧表示 | E-01行20-21 | ○ |
| C-03 | Newボタンでスクリプト追加 | E-01行23-29 | ○ |
| C-04 | デフォルトテンプレートはfunction update | E-01行26 | ○ |
| C-05 | AddScriptCommand使用 | E-01行27 | ○ |
| C-06 | 名前入力フィールド | E-01行63 | ○ |
| C-07 | SetScriptValueCommand使用 | E-01行66 | ○ |
| C-08 | EditボタンでeditScript発火 | E-01行71-77 | ○ |
| C-09 | Removeボタンで確認後削除 | E-01行80-90 | ○ |
| C-10 | RemoveScriptCommand使用 | E-01行86 | ○ |
| C-11 | objectSelectedシグナルで表示切替 | E-01行105-119 | ○ |
| C-12 | Camera選択時は非表示 | E-01行107 | ○ |
| C-13 | editor.scripts[uuid]でスクリプト取得 | E-01行53 | ○ |
| C-14 | scriptAddedシグナルでupdate | E-01行121 | ○ |
| C-15 | scriptRemovedシグナルでupdate | E-01行122 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Sidebar.Script.jsの行番号参照が正確か確認
- [ ] デフォルトスクリプトテンプレートが正しいか確認
- [ ] コマンドクラスの使用箇所が正しいか確認
- [ ] 画面機能マッピングの関連機能が網羅されているか確認
