---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-Sidebar - Settings

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠が確認された。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `editor/js/Sidebar.Settings.js` - SidebarSettingsクラス定義、行1-59
- E-02: `editor/js/Sidebar.Settings.Shortcuts.js` - ショートカット設定、行1-176
- E-03: `editor/js/Sidebar.Settings.History.js` - 履歴管理、行1-147
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 言語選択UI（en/fr/zh/ja/ko/fa） | E-01行20-24 | ○ |
| C-02 | Intl.DisplayNamesで言語名表示 | E-01行22 | ○ |
| C-03 | 言語設定をconfig.setKeyで保存 | E-01行40 | ○ |
| C-04 | SidebarSettingsShortcutsを追加 | E-01行51 | ○ |
| C-05 | SidebarSettingsHistoryを追加 | E-01行52 | ○ |
| C-06 | ショートカット5種（translate/rotate/scale/undo/focus） | E-02行26 | ○ |
| C-07 | isValidKeyBindingでA-Z/0-9検証 | E-02行11-15 | ○ |
| C-08 | IS_MACフラグでMac判定 | E-02行9 | ○ |
| C-09 | Delete/Backspaceでオブジェクト削除 | E-02行102-117 | ○ |
| C-10 | RemoveObjectCommand使用 | E-02行3, 115 | ○ |
| C-11 | transformModeChangedシグナル発火 | E-02行121, 127, 133 | ○ |
| C-12 | Ctrl/Cmd+Z/Shift+ZでUndo/Redo | E-02行137-155 | ○ |
| C-13 | editor.focus()呼び出し | E-02行157-165 | ○ |
| C-14 | persistent永続化チェックボックス | E-03行18-41 | ○ |
| C-15 | history.enableSerialization()呼び出し | E-03行32 | ○ |
| C-16 | UIOutlinerで履歴リスト表示 | E-03行47-57 | ○ |
| C-17 | history.goToState()呼び出し | E-03行52 | ○ |
| C-18 | Clear Historyボタン | E-03行63-73 | ○ |
| C-19 | history.clear()呼び出し | E-03行68 | ○ |
| C-20 | undos正順/redos逆順で表示、redosは透明度0.3 | E-03行90-120 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Sidebar.Settings.jsの行番号参照が正確か確認
- [ ] Sidebar.Settings.Shortcuts.jsのキーバインディング処理が正しいか確認
- [ ] Sidebar.Settings.History.jsのgoToState処理が正しいか確認
- [ ] 画面機能マッピングの関連機能が網羅されているか確認
