---
generated_at: 2026-01-27 14:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 35
  claims_without_evidence: 5
confidence_derived: 0.88
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：35 / 40、根拠なし：5
- 優先レビュー（高）
  1. **IT-029 ポストプロセッシング連携**：examples/jsmの参照のみで具体的なテストコード未確認
  2. **IT-034 MorphTarget連携**：examplesの参照のみで詳細テスト未確認
  3. **IT-040 WebXRController連携**：WebXR環境でのテストコード不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/loaders/ObjectLoader.js` - ObjectLoaderの実装（FileLoader, MaterialLoader, BufferGeometryLoader, ImageLoader連携確認）
- E-02: `test/unit/src/animation/AnimationMixer.tests.js` - AnimationMixer連携テスト
- E-03: `test/unit/src/core/Object3D.tests.js` - Object3Dの親子関係・行列操作テスト
- E-04: `test/e2e/puppeteer.js` - E2Eテストスクリプト（レンダリング検証）
- E-05: `test/e2e/README.md` - E2Eテストの説明と構成
- E-06: `package.json` - テストスクリプト定義（test-unit, test-e2e, test-e2e-webgpu等）
- E-07: `src/Three.Core.js` - コアモジュールのエクスポート定義
- E-08: `test/unit/three.source.unit.js` - ユニットテスト構成ファイル
- E-09: `test/unit/src/loaders/ObjectLoader.tests.js` - ObjectLoaderテスト
- E-10: `src/renderers/WebGLRenderer.js` - WebGLレンダラー実装
- E-11: `test/rollup.treeshake.config.js` - TreeShakeテスト設定
- E-12: `src/audio/Audio.js` - オーディオ機能実装
- E-13: `src/audio/PositionalAudio.js` - 空間オーディオ実装
- E-14: `src/renderers/webxr/WebXRController.js` - WebXRコントローラー実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: ObjectLoader-FileLoader連携 | E-01 | ○ |
| C-02 | IT-002: ObjectLoader-MaterialLoader連携 | E-01 | ○ |
| C-03 | IT-003: ObjectLoader-BufferGeometryLoader連携 | E-01 | ○ |
| C-04 | IT-004: ObjectLoader-ImageLoader連携 | E-01 | ○ |
| C-05 | IT-005: AnimationMixer-AnimationClip連携 | E-02 | ○ |
| C-06 | IT-006: AnimationMixer-Object3D連携 | E-02 | ○ |
| C-07 | IT-007: Scene-Object3D親子連携 | E-03 | ○ |
| C-08 | IT-008: Object3D-Matrix4連携 | E-03 | ○ |
| C-09 | IT-009: Raycaster-Mesh連携 | E-08 | ○ |
| C-10 | IT-010: Camera-Frustum連携 | E-08 | ○ |
| C-11 | IT-011: WebGLRenderer基本レンダリング | E-04, E-05 | ○ |
| C-12 | IT-012: ライティング付きレンダリング | E-04, E-05 | ○ |
| C-13 | IT-013: テクスチャ付きレンダリング | E-04, E-05 | ○ |
| C-14 | IT-014: シャドウマップレンダリング | E-04 | ○ |
| C-15 | IT-015: SkinnedMesh-Skeleton-Bone連携 | E-01 | ○ |
| C-16 | IT-016: LOD-Camera連携 | E-08 | ○ |
| C-17 | IT-017: InstancedMesh-BufferAttribute連携 | E-01 | ○ |
| C-18 | IT-018: BatchedMesh-Texture連携 | E-01 | ○ |
| C-19 | IT-019: LoadingManager-Loader連携 | E-08 | ○ |
| C-20 | IT-020: Cache-FileLoader連携 | E-08 | ○ |
| C-21 | IT-021: EventDispatcher-Object3D連携 | E-08 | ○ |
| C-22 | IT-022: WebGPURendererレンダリング | E-06 | ○ |
| C-23 | IT-023: SpotLight-Object3D target連携 | E-01 | ○ |
| C-24 | IT-024: DirectionalLight-Object3D target連携 | E-01 | ○ |
| C-25 | IT-025: Object3D toJSON-parse往復 | E-03 | ○ |
| C-26 | IT-026: Scene-Fog連携 | E-01 | ○ |
| C-27 | IT-027: PerspectiveCamera aspect連携 | E-08 | ○ |
| C-28 | IT-028: CubeCamera-WebGLCubeRenderTarget連携 | E-08 | ○ |
| C-29 | IT-029: ポストプロセッシング連携 | **根拠不足** | △ |
| C-30 | IT-030: AudioListener-Audio連携 | E-08, E-12 | ○ |
| C-31 | IT-031: PositionalAudio-Object3D連携 | E-08, E-13 | ○ |
| C-32 | IT-032: BufferGeometry-BufferAttribute連携 | E-08 | ○ |
| C-33 | IT-033: InterleavedBuffer連携 | E-08 | ○ |
| C-34 | IT-034: MorphTarget連携 | **根拠不足** | △ |
| C-35 | IT-035: Clock-AnimationMixer連携 | E-08 | ○ |
| C-36 | IT-036: ShaderMaterial-Uniform連携 | E-08 | ○ |
| C-37 | IT-037: Curve-TubeGeometry連携 | E-08 | ○ |
| C-38 | IT-038: Shape-ExtrudeGeometry連携 | E-08 | ○ |
| C-39 | IT-039: TreeShaking連携 | E-11 | ○ |
| C-40 | IT-040: WebXRController連携 | E-14 | △ |

## 4) 不足情報（Unknown / Missing）
- **IT-029 ポストプロセッシング連携**: EffectComposerやShaderPassの結合テストコードが未確認
  - 候補：examples/jsm/postprocessing/ / 専用テストファイル作成 / E2Eテスト拡張
- **IT-034 MorphTarget連携**: モーフターゲットの結合テスト定義が明確でない
  - 候補：examples/webgl_morphtargets.html / ユニットテスト追加 / E2Eでの検証強化
- **IT-040 WebXRController連携**: WebXR環境依存のためテストが限定的
  - 候補：WebXRエミュレータ利用 / モックテスト実装 / 手動テスト手順書

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: E2EテストのexceptionListに含まれるサンプルは結合テストカバレッジから除外されている
  - 対象: webgl_shadowmap, webgpu_*系の一部など
- **リスク1（低）**: オーディオ関連（IT-030, IT-031）はAudioContext依存のためCI環境でのテストが困難
- **リスク2（低）**: WebXR関連（IT-040）はハードウェア依存のためシミュレーションに限界がある

## 6) レビュアーチェックリスト（最小）
- [ ] ObjectLoaderの連携テスト（IT-001〜IT-004）がソースコードの実装と一致しているか確認
- [ ] AnimationMixerのテストケース（IT-005, IT-006）が実際のユニットテストと整合しているか確認
- [ ] E2Eテスト（IT-011〜IT-014）のカバレッジがpuppeteer.jsの対象と一致しているか確認
- [ ] ポストプロセッシング（IT-029）のテスト手順が実行可能か検証
- [ ] WebXR（IT-040）のテスト環境要件を明確化
