---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/core/EventDispatcher.js` - イベントディスパッチ機能の基盤クラス
- E-02: `src/lights/Light.js` - Light.disposeでdisposeイベント発火（57行目）
- E-03: `src/textures/Texture.js` - Texture.disposeでdisposeイベント発火（644行目）
- E-04: `src/materials/Material.js` - Material.disposeでdisposeイベント発火（997行目）
- E-05: `src/core/BufferGeometry.js` - BufferGeometry.disposeでdisposeイベント発火（1452行目）
- E-06: `src/core/RenderTarget.js` - RenderTarget.disposeでdisposeイベント発火（386行目）
- E-07: `src/nodes/core/Node.js` - Node.disposeでdisposeイベント発火（294行目）
- E-08: `src/nodes/gpgpu/ComputeNode.js` - ComputeNode.disposeでdisposeイベント発火（124行目）
- E-09: `src/core/UniformsGroup.js` - UniformsGroup.disposeでdisposeイベント発火（132行目）
- E-10: `src/objects/InstancedMesh.js` - InstancedMesh.disposeでdisposeイベント発火（393行目）
- E-11: `src/renderers/webxr/WebXRController.js` - connected/disconnected/move/pinchstart/pinchendイベント
- E-12: `src/renderers/webxr/WebXRManager.js` - sessionstart/sessionend/planesdetectedイベント
- E-13: `src/renderers/common/XRManager.js` - sessionstart/sessionend/planesdetectedイベント
- E-14: `src/renderers/common/CanvasTarget.js` - resize/disposeイベント（323, 335行目）
- E-15: `src/animation/AnimationAction.js` - finished/loopイベント（763, 816, 842行目）
- E-16: `src/nodes/code/ScriptableValueNode.js` - change/refreshイベント（106, 128行目）
- E-17: `src/utils.js` - log, warn, error, warnOnce, setConsoleFunction関数（178-292行目）
- E-18: `src/loaders/LoadingManager.js` - onStart/onProgress/onLoad/onErrorコールバック（27-148行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | disposeイベント - リソース破棄時に発火 | E-02, E-03, E-04, E-05, E-06, E-07, E-08, E-09, E-10 | ○ |
| C-02 | connectedイベント - WebXRコントローラー接続時 | E-11 (175行目) | ○ |
| C-03 | disconnectedイベント - WebXRコントローラー切断時 | E-11 (189行目) | ○ |
| C-04 | moveイベント - WebXRコントローラー移動時 | E-11 (4行目) | ○ |
| C-05 | pinchstartイベント - ピンチジェスチャー開始時 | E-11 (283行目) | ○ |
| C-06 | pinchendイベント - ピンチジェスチャー終了時 | E-11 (274行目) | ○ |
| C-07 | sessionstartイベント - WebXRセッション開始時 | E-12 (516行目), E-13 (1088行目) | ○ |
| C-08 | sessionendイベント - WebXRセッション終了時 | E-12 (265行目), E-13 (1443行目) | ○ |
| C-09 | planesdetectedイベント - WebXR平面検出時 | E-12 (1079行目), E-13 (1669行目) | ○ |
| C-10 | resizeイベント - CanvasTargetサイズ変更時 | E-14 (323行目) | ○ |
| C-11 | finishedイベント - アニメーション終了時 | E-15 (763, 816行目) | ○ |
| C-12 | loopイベント - アニメーションループ時 | E-15 (843行目) | ○ |
| C-13 | changeイベント - ScriptableValue変更時 | E-16 (106行目) | ○ |
| C-14 | refreshイベント - ScriptableValueリフレッシュ時 | E-16 (128行目) | ○ |
| C-15 | log関数 - 情報メッセージ出力 | E-17 (205-219行目) | ○ |
| C-16 | warn関数 - 警告メッセージ出力 | E-17 (231-245行目) | ○ |
| C-17 | error関数 - エラーメッセージ出力 | E-17 (257-271行目) | ○ |
| C-18 | warnOnce関数 - 重複しない警告出力 | E-17 (282-292行目) | ○ |
| C-19 | onStartコールバック - ローディング開始時 | E-18 (86-102行目) | ○ |
| C-20 | onProgressコールバック - アイテム読み込み完了時 | E-18 (110-131行目) | ○ |
| C-21 | onLoadコールバック - 全アイテム読み込み完了時 | E-18 (120-129行目) | ○ |
| C-22 | onErrorコールバック - 読み込みエラー時 | E-18 (140-148行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての通知機能についてソースコードから直接確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで直接確認可能

### 補足事項
- Three.jsはWebGLベースの3Dグラフィックスライブラリであり、一般的なアプリケーション通知機能（メール送信、プッシュ通知、SMS等）は含まれていない
- 本一覧はライブラリ内部のイベント通知メカニズム、コンソール出力、ローディングコールバックを対象としている
- EventDispatcherを継承したクラスは追加のカスタムイベントをディスパッチ可能であるが、本一覧はライブラリに標準実装されているものを対象としている

## 6) レビュアーチェックリスト（最小）
- [ ] EventDispatcherベースのイベント通知が網羅されているか確認
- [ ] コンソール出力関数の使用方法が正確に記載されているか確認
- [ ] LoadingManagerコールバックの引数情報が正確か確認
- [ ] WebXR関連のイベントが漏れなく記載されているか確認
- [ ] 各イベントの発火タイミングがソースコードと一致しているか確認
