# 通知設計書 10-resize

## 概要

本ドキュメントは、three.jsライブラリにおける`resize`イベント通知の設計について記載する。`resize`イベントは、レンダラーのキャンバスサイズが変更された際にCanvasTargetから発火するイベントである。

### 本通知の処理概要

`resize`イベントは、three.jsのレンダリングキャンバスのサイズが変更された際に発火するイベントであり、レンダリングパイプラインの各コンポーネントにサイズ変更を通知するために使用される。

**業務上の目的・背景**：WebGLやWebGPUアプリケーションでは、ブラウザウィンドウのリサイズ、フルスクリーン切り替え、レスポンシブデザインの対応等でキャンバスサイズが変更されることがある。`resize`イベントにより、ポストプロセッシングエフェクト、レンダーターゲット、カメラのアスペクト比等を適切に更新できる。

**通知の送信タイミング**：`CanvasTarget.setSize()`または`setDrawingBufferSize()`メソッドが呼び出された際に、`_dispatchResize()`を通じて発火される。

**通知の受信者**：CanvasTargetに対して`addEventListener('resize', callback)`で登録されたリスナーが受信者となる。レンダラー内部のコンポーネントや、アプリケーションのポストプロセッシングパスが主な受信者。

**通知内容の概要**：イベントオブジェクトには`type: 'resize'`のみが含まれる。新しいサイズはCanvasTargetのプロパティから取得する。

**期待されるアクション**：受信者は、レンダーターゲットのサイズ更新、ポストプロセッシングシェーダーのリソース再生成、カメラのアスペクト比更新等を実行する。

## 通知種別

アプリ内イベント通知（EventDispatcherパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

CanvasTargetの`_listeners`オブジェクトに登録されている`resize`タイプのリスナー関数すべてに対して、登録順に通知が送信される。

## 通知テンプレート

### イベントオブジェクト形式

| 項目 | 内容 |
|-----|------|
| type | 'resize' |
| target | CanvasTargetインスタンス（自動設定） |

### イベントオブジェクト例

```javascript
{
  type: 'resize',
  target: <CanvasTarget>
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| type | イベントタイプ | 固定値 'resize' | Yes |
| target | イベント発火元オブジェクト | EventDispatcher.dispatchEvent内で自動設定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | CanvasTarget.setSize() | 常に送信 | サイズ変更メソッドが呼び出された時 |
| API呼び出し | CanvasTarget.setDrawingBufferSize() | 常に送信 | 描画バッファサイズ変更時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| XRプレゼンテーション中 | xr.isPresentingがtrueの場合、setSize/setDrawingBufferSize自体が早期リターン |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[setSize/setDrawingBufferSize呼び出し] --> B{xr.isPresenting?}
    B -->|Yes| C[処理終了 早期リターン]
    B -->|No| D[_width, _height更新]
    D --> E[domElement.width/height更新]
    E --> F[setViewport呼び出し]
    F --> G[_dispatchResize呼び出し]
    G --> H[dispatchEvent type: resize]
    H --> I[処理終了]
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナーエラー | リスナー関数内で例外が発生 | 例外はキャッチされず呼び出し元に伝播 |

### リトライ仕様

リトライなし

## 配信設定

### レート制限

制限なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 特になし

## 備考

- XRプレゼンテーション中はリサイズが無効化される
- setSize()はupdateStyle引数でDOM要素のstyle属性更新も制御可能
- pixelRatioの変更時にもsetSizeが呼ばれ、resizeイベントが発火する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: _dispatchResize()メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CanvasTarget.js | `src/renderers/common/CanvasTarget.js` | 321-325行目の_dispatchResize()メソッド |

**主要処理フロー**:
1. **323行目**: `this.dispatchEvent( { type: 'resize' } )`でイベント発火

#### Step 2: setSize()メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CanvasTarget.js | `src/renderers/common/CanvasTarget.js` | 185-207行目のsetSize()メソッド |

**主要処理フロー**:
1. **188行目**: XRプレゼンテーション中は早期リターン
2. **190-194行目**: サイズとDOM要素の更新
3. **203行目**: setViewport()呼び出し
4. **205行目**: _dispatchResize()呼び出し

#### Step 3: setDrawingBufferSize()メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CanvasTarget.js | `src/renderers/common/CanvasTarget.js` | 159-176行目のsetDrawingBufferSize()メソッド |

### プログラム呼び出し階層図

```
アプリケーションコード
    │
    ├─ renderer.setSize(width, height)
    │      │
    │      └─ CanvasTarget.setSize(width, height, updateStyle)
    │             │
    │             ├─ XRプレゼンテーションチェック
    │             ├─ _width, _height更新
    │             ├─ domElement.width/height更新
    │             ├─ domElement.style更新（オプション）
    │             ├─ setViewport()
    │             │
    │             └─ _dispatchResize()
    │                    │
    │                    └─ this.dispatchEvent({ type: 'resize' })
    │                           │
    │                           └─ リスナー呼び出し
    │
    └─ renderer.setDrawingBufferSize(width, height, pixelRatio)
           │
           └─ 同様の処理フロー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CanvasTarget.js | `src/renderers/common/CanvasTarget.js` | ソース | resizeイベント発火、setSize/setDrawingBufferSizeメソッド |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント発火の基盤クラス |
