# 通知設計書 16-warn

## 概要

本ドキュメントは、Three.jsのユーティリティ関数における `warn` 通知（コンソール警告出力）の設計を記述する。この通知は、警告メッセージをコンソールに出力する。

### 本通知の処理概要

この通知は、Three.jsライブラリ内部から警告メッセージを出力するためのユーティリティ関数である。出力メッセージには自動的に「THREE.」プレフィックスが付与される。

**業務上の目的・背景**：3Dアプリケーション開発において、潜在的な問題や非推奨の使用法を開発者に警告することは重要である。warn関数は、パフォーマンスに影響する使用法、非推奨のAPIの使用、設定ミスの可能性などを開発者に通知するために使用される。「THREE.」プレフィックスにより、Three.js固有の警告であることが明確になる。

**通知の送信タイミング**：Three.jsライブラリ内部のコードからwarn()関数が呼び出された際に発火する。警告レベルのメッセージを出力する場合に使用される。

**通知の受信者**：ブラウザのコンソール（Developer Tools）。setConsoleFunction()でカスタム関数が設定されている場合は、そのカスタム関数がメッセージを受信する。

**通知内容の概要**：「THREE.」プレフィックス付きの警告メッセージと、追加のパラメータ（オプション）がコンソールに出力される。

**期待されるアクション**：開発者はコンソールで警告を確認し、コードの改善や設定の見直しを行う。非推奨のAPIを使用している場合は代替APIへの移行を検討する。

## 通知種別

コンソール出力（console.warn または カスタムコンソール関数）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中（警告レベル） |
| リトライ | なし |

### 送信先決定ロジック

1. setConsoleFunction()でカスタム関数が設定されている場合、そのカスタム関数が呼び出される
2. カスタム関数が設定されていない場合、console.warn()が呼び出される

## 通知テンプレート

### 出力形式

```javascript
// カスタム関数なしの場合
console.warn('THREE.' + methodName, ...additionalParams)

// カスタム関数ありの場合
customFunction('warn', 'THREE.' + methodName, ...additionalParams)
```

### 使用例

```javascript
import { warn } from 'three';

// 内部使用例
warn('WebGLRenderer: Texture format not supported.');
warn('Material.alphaTest:', 'Value should be between 0 and 1.');
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| methodName | メソッド名/メッセージの先頭部分 | params[0]（第1引数） | Yes |
| additionalParams | 追加パラメータ | params[1..n]（残りの引数） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 関数呼び出し | warn()関数呼び出し | 常に | 警告メッセージの出力 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | warn()関数が呼び出されると常に出力される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[warn関数呼び出し] --> B[メッセージ生成]
    B --> C["'THREE.' + params[0]"]
    C --> D{カスタム関数設定あり?}
    D -->|Yes| E[カスタム関数呼び出し]
    D -->|No| F[console.warn呼び出し]
    E --> G[終了]
    F --> G
```

## データベース参照・更新仕様

本通知はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| カスタム関数内例外 | カスタム関数が例外を発生 | 例外は呼び出し元に伝播 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- 機密情報を警告メッセージに含めないよう注意が必要
- 本番環境ではsetConsoleFunction()でログ出力を制御可能

## 備考

- 「THREE.」プレフィックスは自動的に付与される
- 重複した警告を防ぎたい場合はwarnOnce()関数を使用する
- warn関数はwarnOnce()関数から内部的に呼び出されることもある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コンソール関数の管理構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | utils.js | `src/utils.js` | _setConsoleFunction変数とsetConsoleFunction関数 |

**読解のコツ**: warn関数はlog関数と同じ構造を持つ。_setConsoleFunction変数がnullの場合はネイティブのconsole.warnが使用される。

#### Step 2: warn関数の実装を理解する

warn関数の実装と動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | utils.js | `src/utils.js` | warn関数（231-245行目） |

**主要処理フロー**:
- **233行目**: メッセージ生成（'THREE.' + params.shift()）
- **235-237行目**: カスタム関数がある場合の処理
- **239-243行目**: カスタム関数がない場合の処理（console.warn呼び出し）

### プログラム呼び出し階層図

```
warn(...params)
    |
    +-- const message = 'THREE.' + params.shift()
    |
    +-- [カスタム関数チェック]
           |
           ├── _setConsoleFunction !== null
           |      |
           |      +-- _setConsoleFunction('warn', message, ...params)
           |
           └── _setConsoleFunction === null
                  |
                  +-- console.warn(message, ...params)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

params ─────────> warn() ─────────────> コンソール/カスタム関数
                    |
                    v
            ['THREE.' + params[0], ...rest]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| utils.js | `src/utils.js` | ソース | log/warn/error関数の定義 |
| Three.Core.js | `src/Three.Core.js` | ソース | utilsのエクスポート |
