# 通知設計書 4-move

## 概要

本ドキュメントは、three.jsライブラリにおける`move`イベント通知の設計について記載する。`move`イベントは、WebXRコントローラーの位置が更新された際に発火するイベントである。

### 本通知の処理概要

`move`イベントは、WebXR APIを使用したVR/ARアプリケーションにおいて、コントローラーのリアルタイムな位置変更を検知するためのイベントである。

**業務上の目的・背景**：WebXRアプリケーションでは、ユーザーのコントローラーの動きに応じてレーザーポインターの表示、オブジェクトの移動、UI要素のハイライト等を行う必要がある。`move`イベントにより、アプリケーションはコントローラーの位置変更をフレームごとに検知し、リアルタイムなインタラクションを実現できる。

**通知の送信タイミング**：XRフレームごとの更新処理（update()メソッド）で、targetRayの入力ポーズが正常に取得できた際に発火される。つまり、コントローラーがトラッキングされている間、毎フレーム発火される。

**通知の受信者**：`move`イベントの受信者は、XRコントローラーの各座標空間（targetRay、grip、hand）を表すGroupオブジェクトに登録されたリスナーである。

**通知内容の概要**：イベントオブジェクトには`type: 'move'`のみが含まれる。位置情報はコントローラーのGroupオブジェクト自体のmatrix/position/rotationから取得する。

**期待されるアクション**：受信者は、コントローラーの新しい位置に基づいてレイキャストを実行し、ポイントしているオブジェクトを特定したり、ドラッグ操作中のオブジェクトを移動させたりする。

## 通知種別

アプリ内イベント通知（EventDispatcherパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 通常 |
| リトライ | 無 |

### 送信先決定ロジック

WebXRControllerクラスの`dispatchEvent()`メソッドにより、targetRay、grip、handの3つのGroupオブジェクトに対して順次イベントが送信される。

## 通知テンプレート

### イベントオブジェクト形式

| 項目 | 内容 |
|-----|------|
| type | 'move' |
| target | dispatchEvent実行元Groupオブジェクト（自動設定） |

### イベントオブジェクト例

```javascript
{
  type: 'move',
  target: <Group>
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| type | イベントタイプ | 固定値 'move' | Yes |
| target | イベント発火元オブジェクト | EventDispatcher.dispatchEvent内で自動設定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| フレーム更新 | WebXRController.update() | inputPoseがnullでない | targetRayの入力ポーズが正常に取得できた時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| inputPoseがnull | コントローラーの位置が取得できない場合 |
| visibilityStateが'visible-blurred' | XRセッションの可視状態がblurredの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[onAnimationFrame] --> B[controller.update inputSource, frame, referenceSpace]
    B --> C{visibilityState != visible-blurred?}
    C -->|No| D[処理スキップ]
    C -->|Yes| E[inputPose取得]
    E --> F{inputPoseがnullでない?}
    F -->|No| D
    F -->|Yes| G[targetRayのmatrix更新]
    G --> H[dispatchEvent _moveEvent]
    H --> I[終了]
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナーエラー | リスナー関数内で例外が発生 | 例外はキャッチされず呼び出し元に伝播 |

### リトライ仕様

リトライなし

## 配信設定

### レート制限

制限なし（フレームごとに発火）

### 配信時間帯

制限なし（XRセッション中のみ発火）

## セキュリティ考慮事項

- 位置情報が含まれるが、WebXR API自体がユーザー許可を必要とする

## 備考

- `_moveEvent`はファイル先頭で定義された再利用オブジェクト（パフォーマンス最適化）
- 位置・回転情報はイベントに含まれず、Groupオブジェクトのmatrix/position/rotationから取得
- handモードでは`move`イベントは発火しない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: イベントオブジェクトの定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebXRController.js | `src/renderers/webxr/WebXRController.js` | 4行目の`_moveEvent`定義 |

**読解のコツ**: `const _moveEvent = { type: 'move' };`として定義されており、毎フレームのオブジェクト生成を避けている。

#### Step 2: イベント発火ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WebXRController.js | `src/renderers/webxr/WebXRController.js` | 223-376行目のupdate()メソッド、特に369行目 |

**主要処理フロー**:
1. **233行目**: visibilityStateのチェック
2. **330-372行目**: targetRayの位置更新処理
3. **369行目**: `this.dispatchEvent( _moveEvent )`でイベント発火

### プログラム呼び出し階層図

```
WebXRManager.onAnimationFrame
    │
    └─ controller.update(inputSource, frame, referenceSpace)
           │
           ├─ inputPose = frame.getPose()
           │
           ├─ targetRay.matrix.fromArray()
           │
           └─ this.dispatchEvent(_moveEvent)
                  │
                  ├─ _targetRay.dispatchEvent(event)
                  ├─ _grip.dispatchEvent(event)
                  └─ _hand.dispatchEvent(event)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WebXRController.js | `src/renderers/webxr/WebXRController.js` | ソース | moveイベント発火、update()メソッド |
| WebXRManager.js | `src/renderers/webxr/WebXRManager.js` | ソース | onAnimationFrameからupdate呼び出し |
