# 通知設計書 7-sessionstart

## 概要

本ドキュメントは、three.jsライブラリにおける`sessionstart`イベント通知の設計について記載する。`sessionstart`イベントは、WebXRセッションが開始された際にWebXRManagerから発火するイベントである。

### 本通知の処理概要

`sessionstart`イベントは、WebXR APIを使用したVR/ARアプリケーションにおいて、XRセッションの開始を検知するためのイベントである。

**業務上の目的・背景**：WebXRアプリケーションでは、VR/ARモードへの切り替えを検知し、レンダリングの設定変更、UIの調整、オーディオの初期化等を行う必要がある。`sessionstart`イベントにより、アプリケーションはXRセッションの開始を確実に検知し、XR専用の処理を開始できる。

**通知の送信タイミング**：`WebXRManager.setSession()`が呼び出され、XRセッションのセットアップが完了した後に発火される。具体的には、参照スペースの取得、アニメーションループの開始、`isPresenting = true`の設定後に発火。

**通知の受信者**：WebXRManagerに対して`addEventListener('sessionstart', callback)`で登録されたリスナーが受信者となる。

**通知内容の概要**：イベントオブジェクトには`type: 'sessionstart'`のみが含まれる。

**期待されるアクション**：受信者は、XR専用のUI表示、カメラ設定の変更、通常のDOM UIの非表示化、XRコントローラーのセットアップ等を実行する。

## 通知種別

アプリ内イベント通知（EventDispatcherパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

WebXRManagerの`_listeners`オブジェクトに登録されている`sessionstart`タイプのリスナー関数すべてに対して、登録順に通知が送信される。

## 通知テンプレート

### イベントオブジェクト形式

| 項目 | 内容 |
|-----|------|
| type | 'sessionstart' |
| target | WebXRManagerインスタンス（自動設定） |

### イベントオブジェクト例

```javascript
{
  type: 'sessionstart',
  target: <WebXRManager>
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| type | イベントタイプ | 固定値 'sessionstart' | Yes |
| target | イベント発火元オブジェクト | EventDispatcher.dispatchEvent内で自動設定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | WebXRManager.setSession() | セッション設定完了後 | XRセッションのセットアップが完了した時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| session === null | セッションがnullの場合、setSession内の処理自体がスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[WebXRManager.setSession session 呼び出し] --> B{session !== null?}
    B -->|No| C[処理終了]
    B -->|Yes| D[初期レンダーターゲット保存]
    D --> E[セッションイベントリスナー登録]
    E --> F[XR互換性確認/設定]
    F --> G[レイヤー作成/設定]
    G --> H[参照スペース取得]
    H --> I[アニメーションループ開始]
    I --> J[scope.isPresenting = true]
    J --> K[dispatchEvent type: sessionstart]
    K --> L[処理終了]
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナーエラー | リスナー関数内で例外が発生 | 例外はキャッチされず呼び出し元に伝播 |

### リトライ仕様

リトライなし

## 配信設定

### レート制限

制限なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- XRセッションの開始にはユーザーのジェスチャー（ボタンクリック等）が必要

## 備考

- sessionstartはXRセッションのライフサイクルにおいて一度だけ発火
- isPresenting フラグはsessionstart発火前にtrueに設定される
- setSession()はasync関数であり、参照スペースの取得等で待機が発生

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: setSession()メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebXRManager.js | `src/renderers/webxr/WebXRManager.js` | 397-520行目のsetSession()メソッド |

**主要処理フロー**:
1. **401行目**: session !== null のチェック
2. **403-412行目**: セッションイベントリスナー登録
3. **419-502行目**: レイヤー作成、参照スペース取得
4. **509-512行目**: referenceSpaceの取得（await）
5. **514行目**: scope.isPresenting = true
6. **516行目**: `scope.dispatchEvent( { type: 'sessionstart' } )`でイベント発火

### プログラム呼び出し階層図

```
アプリケーションコード
    │
    └─ renderer.xr.setSession(xrSession)
           │
           ├─ session.addEventListener('select', ...)
           ├─ session.addEventListener('end', ...)
           │
           ├─ gl.makeXRCompatible()
           │
           ├─ XRWebGLLayer/XRProjectionLayer 作成
           │
           ├─ session.requestReferenceSpace()
           │
           ├─ animation.setContext(session)
           ├─ animation.start()
           │
           ├─ scope.isPresenting = true
           │
           └─ scope.dispatchEvent({ type: 'sessionstart' })
                  │
                  └─ リスナー呼び出し
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WebXRManager.js | `src/renderers/webxr/WebXRManager.js` | ソース | sessionstartイベント発火、setSession()メソッド |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント発火の基盤クラス |
