# 通知設計書 8-sessionend

## 概要

本ドキュメントは、three.jsライブラリにおける`sessionend`イベント通知の設計について記載する。`sessionend`イベントは、WebXRセッションが終了した際にWebXRManagerから発火するイベントである。

### 本通知の処理概要

`sessionend`イベントは、WebXR APIを使用したVR/ARアプリケーションにおいて、XRセッションの終了を検知するためのイベントである。

**業務上の目的・背景**：WebXRアプリケーションでは、VR/ARモードからの離脱を検知し、通常のレンダリング設定への復帰、UIの復元、リソースの解放等を行う必要がある。`sessionend`イベントにより、アプリケーションはXRセッションの終了を確実に検知し、通常モードへの移行処理を実行できる。

**通知の送信タイミング**：XRセッションの`end`イベントを受けて、`onSessionEnd()`関数内でクリーンアップ処理が完了した後に発火される。

**通知の受信者**：WebXRManagerに対して`addEventListener('sessionend', callback)`で登録されたリスナーが受信者となる。

**通知内容の概要**：イベントオブジェクトには`type: 'sessionend'`のみが含まれる。

**期待されるアクション**：受信者は、通常のDOM UIの表示復元、レンダリング設定の復帰、XR専用リソースの解放、ゲーム状態の一時停止等を実行する。

## 通知種別

アプリ内イベント通知（EventDispatcherパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

WebXRManagerの`_listeners`オブジェクトに登録されている`sessionend`タイプのリスナー関数すべてに対して、登録順に通知が送信される。

## 通知テンプレート

### イベントオブジェクト形式

| 項目 | 内容 |
|-----|------|
| type | 'sessionend' |
| target | WebXRManagerインスタンス（自動設定） |

### イベントオブジェクト例

```javascript
{
  type: 'sessionend',
  target: <WebXRManager>
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| type | イベントタイプ | 固定値 'sessionend' | Yes |
| target | イベント発火元オブジェクト | EventDispatcher.dispatchEvent内で自動設定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| WebXR API | XRSession 'end'イベント | セッション終了時 | XRセッションが終了した時 |

### 送信抑止条件

なし（セッション終了時は必ず発火）

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[XRSession 'end'イベント発火] --> B[onSessionEnd関数呼び出し]
    B --> C[セッションイベントリスナー削除]
    C --> D[全コントローラーdisconnect]
    D --> E[内部状態リセット]
    E --> F[animation.stop]
    F --> G[scope.isPresenting = false]
    G --> H[ピクセル比率/サイズ復元]
    H --> I[dispatchEvent type: sessionend]
    I --> J[処理終了]
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナーエラー | リスナー関数内で例外が発生 | 例外はキャッチされず呼び出し元に伝播 |

### リトライ仕様

リトライなし

## 配信設定

### レート制限

制限なし

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 特になし

## 備考

- sessionendはXRセッションのライフサイクルにおいて一度だけ発火
- isPresenting = false はsessionend発火前に設定される
- 全コントローラーに対してdisconnectが呼び出された後に発火

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: onSessionEnd()関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebXRManager.js | `src/renderers/webxr/WebXRManager.js` | 213-267行目のonSessionEnd()関数 |

**主要処理フロー**:
1. **215-222行目**: セッションイベントリスナーの削除
2. **224-234行目**: 全コントローラーのdisconnect
3. **236-254行目**: 内部状態のリセット（depthNear/Far、depthSensing、cameraAccessTextures等）
4. **258行目**: animation.stop()
5. **260行目**: scope.isPresenting = false
6. **262-263行目**: ピクセル比率とサイズの復元
7. **265行目**: `scope.dispatchEvent( { type: 'sessionend' } )`でイベント発火

### プログラム呼び出し階層図

```
XRSession
    │
    └─ 'end' イベント
           │
           └─ onSessionEnd()
                  │
                  ├─ session.removeEventListener('select', ...)
                  ├─ session.removeEventListener('end', ...)
                  │
                  ├─ controllers[i].disconnect(inputSource)  // 全コントローラー
                  │
                  ├─ 内部状態リセット
                  │      ├─ depthSensing.reset()
                  │      ├─ cameraAccessTextures クリア
                  │      └─ session/layer変数null化
                  │
                  ├─ animation.stop()
                  │
                  ├─ scope.isPresenting = false
                  │
                  ├─ renderer.setPixelRatio/setSize（復元）
                  │
                  └─ scope.dispatchEvent({ type: 'sessionend' })
                         │
                         └─ リスナー呼び出し
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WebXRManager.js | `src/renderers/webxr/WebXRManager.js` | ソース | sessionendイベント発火、onSessionEnd()関数 |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント発火の基盤クラス |
