# 通知設計書 9-planesdetected

## 概要

本ドキュメントは、three.jsライブラリにおける`planesdetected`イベント通知の設計について記載する。`planesdetected`イベントは、WebXR ARセッションにおいて平面が検出された際にWebXRManagerから発火するイベントである。

### 本通知の処理概要

`planesdetected`イベントは、WebXR APIのplane detection機能を使用したARアプリケーションにおいて、現実世界の平面（床、壁、テーブル等）が検出されたことを通知するためのイベントである。

**業務上の目的・背景**：WebXR ARアプリケーションでは、現実世界の平面を検出し、その上にバーチャルオブジェクトを配置することが一般的なユースケースである。`planesdetected`イベントにより、アプリケーションは検出された平面の情報を取得し、オブジェクトの適切な配置、オクルージョン処理、物理シミュレーションの境界設定等を行える。

**通知の送信タイミング**：XRフレームの更新処理（onAnimationFrame）で、`frame.detectedPlanes`が存在する場合に毎フレーム発火される。

**通知の受信者**：WebXRManagerに対して`addEventListener('planesdetected', callback)`で登録されたリスナーが受信者となる。

**通知内容の概要**：イベントオブジェクトには`type: 'planesdetected'`と`data`プロパティが含まれ、`data`にはXRFrame参照が設定される。これにより、`frame.detectedPlanes`から検出された平面の情報を取得できる。

**期待されるアクション**：受信者は、検出された平面の情報を取得し、平面メッシュの生成/更新、オブジェクト配置可能領域の更新、物理シミュレーションの境界設定等を実行する。

## 通知種別

アプリ内イベント通知（EventDispatcherパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 通常 |
| リトライ | 無 |

### 送信先決定ロジック

WebXRManagerの`_listeners`オブジェクトに登録されている`planesdetected`タイプのリスナー関数すべてに対して、登録順に通知が送信される。

## 通知テンプレート

### イベントオブジェクト形式

| 項目 | 内容 |
|-----|------|
| type | 'planesdetected' |
| data | XRFrameオブジェクト |
| target | WebXRManagerインスタンス（自動設定） |

### イベントオブジェクト例

```javascript
{
  type: 'planesdetected',
  data: XRFrame,  // frame.detectedPlanesにアクセス可能
  target: <WebXRManager>
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| type | イベントタイプ | 固定値 'planesdetected' | Yes |
| data | XRFrameオブジェクト | onAnimationFrameのframe引数 | Yes |
| target | イベント発火元オブジェクト | EventDispatcher.dispatchEvent内で自動設定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| フレーム更新 | onAnimationFrame | frame.detectedPlanesが存在 | XRフレームで平面が検出された時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| frame.detectedPlanes が falsy | 平面検出結果が存在しない場合 |
| plane-detection feature未有効 | XRセッションでplane-detection機能が有効でない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[onAnimationFrame time, frame] --> B[コントローラー更新等の処理]
    B --> C{frame.detectedPlanes?}
    C -->|No| D[処理スキップ]
    C -->|Yes| E[dispatchEvent type: planesdetected, data: frame]
    E --> F[処理終了]
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナーエラー | リスナー関数内で例外が発生 | 例外はキャッチされず呼び出し元に伝播 |

### リトライ仕様

リトライなし

## 配信設定

### レート制限

制限なし（フレームごとに発火可能）

### 配信時間帯

制限なし（XRセッション中、plane-detection有効時のみ発火）

## セキュリティ考慮事項

- 平面検出データには現実世界の環境情報が含まれるため、プライバシーに配慮が必要
- WebXR plane-detection機能はユーザー許可が必要

## 備考

- plane-detection機能はWebXR AR向けの機能であり、VRセッションでは通常使用されない
- detectedPlanesはSet型であり、各平面のポリゴン頂点、中心位置、向き等の情報を含む
- 平面情報は動的に更新されるため、毎フレームの処理が必要

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: イベント発火箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebXRManager.js | `src/renderers/webxr/WebXRManager.js` | 1077-1081行目のplanesdetected発火処理 |

**主要処理フロー**:
1. **1077行目**: `if ( frame.detectedPlanes )`で平面検出結果の存在確認
2. **1079行目**: `scope.dispatchEvent( { type: 'planesdetected', data: frame } )`でイベント発火

### プログラム呼び出し階層図

```
WebXRManager.onAnimationFrame(time, frame)
    │
    ├─ pose = frame.getViewerPose()
    │
    ├─ カメラ更新処理
    │
    ├─ depth sensing処理
    │
    ├─ camera access処理
    │
    ├─ コントローラー更新
    │
    ├─ onAnimationFrameCallback呼び出し
    │
    └─ frame.detectedPlanes チェック
           │
           └─ scope.dispatchEvent({
                  type: 'planesdetected',
                  data: frame
              })
                  │
                  └─ リスナー呼び出し
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WebXRManager.js | `src/renderers/webxr/WebXRManager.js` | ソース | planesdetectedイベント発火 |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント発火の基盤クラス |
