---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-dispose.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/core/EventDispatcher.js` 全体（1-132行目）
- E-02: `src/textures/Texture.js` 636-646行目 dispose()メソッド
- E-03: `src/materials/Material.js` 989-998行目 dispose()メソッド
- E-04: `src/core/BufferGeometry.js` 1450-1454行目 dispose()メソッド
- E-05: `src/lights/Light.js` 55-59行目 dispose()メソッド
- E-06: `src/core/RenderTarget.js` 384-388行目 dispose()メソッド
- E-07: `src/core/UniformsGroup.js` 130-134行目 dispose()メソッド
- E-08: `src/nodes/core/Node.js` 292-296行目 dispose()メソッド
- E-09: `src/nodes/gpgpu/ComputeNode.js` 122-126行目 dispose()メソッド
- E-10: `src/objects/InstancedMesh.js` 391-402行目 dispose()メソッド
- E-11: `src/renderers/common/CanvasTarget.js` 333-337行目 dispose()メソッド
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 2行目 dispose通知の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | disposeイベントはEventDispatcherを継承したクラスで使用される | E-01 (EventDispatcherクラス定義), E-02-E-11 (各クラスがEventDispatcher継承) | ○ |
| C-02 | Textureクラスがdisposeイベントを発火する | E-02 (644行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-03 | Materialクラスがdisposeイベントを発火する | E-03 (997行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-04 | BufferGeometryクラスがdisposeイベントを発火する | E-04 (1452行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-05 | Lightクラスがdisposeイベントを発火する | E-05 (57行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-06 | RenderTargetクラスがdisposeイベントを発火する | E-06 (386行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-07 | UniformsGroupクラスがdisposeイベントを発火する | E-07 (132行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-08 | Nodeクラスがdisposeイベントを発火する | E-08 (294行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-09 | ComputeNodeクラスがdisposeイベントを発火する | E-09 (124行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-10 | InstancedMeshクラスがdisposeイベントを発火する | E-10 (393行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-11 | CanvasTargetクラスがdisposeイベントを発火する | E-11 (335行目: `this.dispatchEvent( { type: 'dispose' } )`) | ○ |
| C-12 | イベントオブジェクトにはtype:'dispose'のみが含まれる | E-02-E-11 (全て `{ type: 'dispose' }` のみを渡している) | ○ |
| C-13 | event.targetはdispatchEvent内で自動設定される | E-01 (111行目: `event.target = this`) | ○ |
| C-14 | dispatchEventはリスナー配列をコピーしてから呼び出す | E-01 (114行目: `const array = listenerArray.slice( 0 )`) | ○ |
| C-15 | dispatchEvent終了時にevent.targetはnullにリセットされる | E-01 (122行目: `event.target = null`) | ○ |
| C-16 | _listenersはeventType別にリスナー配列を管理する | E-01 (37-39行目: `listeners[ type ] = []`) | ○ |
| C-17 | addEventListenerで重複リスナー登録を防止する | E-01 (43行目: `if ( listeners[ type ].indexOf( listener ) === - 1 )`) | ○ |
| C-18 | RenderTarget.setSize()で内部的にdispose()が呼ばれる | E-06 (310行目: `this.dispose()`) | ○ |
| C-19 | 送信方式は同期である | E-01 (116-120行目: forループで直接call) | ○ |
| C-20 | InstancedMesh.dispose()はmorphTextureも解放する | E-10 (395-400行目: morphTexture?.dispose()) | ○ |
| C-21 | 通知一覧でdisposeは「イベント通知」カテゴリである | E-12 (2行目: カテゴリ="イベント通知") | ○ |
| C-22 | disposeはGPUリソース破棄時に発火する | E-12 (2行目: 説明欄), E-02 (636行目JSDoc) | ○ |
| C-23 | Textureクラスはdispose時に@fires Texture#disposeイベントを発行 | E-02 (634行目: `@fires Texture#dispose`) | ○ |
| C-24 | Materialクラスはdispose時に@fires Material#disposeイベントを発行 | E-03 (987行目: `@fires Material#dispose`) | ○ |
| C-25 | EventDispatcherクラスは独立したモジュールとして提供される | E-01 (1-132行目: 単一クラスのモジュール) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に対してソースコードから根拠を確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 全てのdispose()実装が`dispatchEvent({ type: 'dispose' })`を呼び出していることを確認
- [x] EventDispatcher.dispatchEvent()の実装が主張と一致することを確認
- [x] 通知一覧.csvとの整合性を確認
