---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-resize.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/renderers/common/CanvasTarget.js` 321-325行目 _dispatchResize()メソッド
- E-02: `src/renderers/common/CanvasTarget.js` 185-207行目 setSize()メソッド
- E-03: `src/renderers/common/CanvasTarget.js` 159-176行目 setDrawingBufferSize()メソッド
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 11行目 resize通知の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | resizeイベントは_dispatchResize()で発火される | E-01 (323行目: `this.dispatchEvent( { type: 'resize' } )`) | ○ |
| C-02 | イベントオブジェクトにはtypeのみ含まれる | E-01 (`{ type: 'resize' }`のみ) | ○ |
| C-03 | setSize()で_dispatchResize()が呼び出される | E-02 (205行目: `this._dispatchResize()`) | ○ |
| C-04 | setDrawingBufferSize()で_dispatchResize()が呼び出される | E-03 (174行目: `this._dispatchResize()`) | ○ |
| C-05 | XRプレゼンテーション中はsetSizeが早期リターン | E-02 (188行目: `if ( this.xr && this.xr.isPresenting ) return`) | ○ |
| C-06 | XRプレゼンテーション中はsetDrawingBufferSizeが早期リターン | E-03 (162行目: `if ( this.xr && this.xr.isPresenting ) return`) | ○ |
| C-07 | setSize()でdomElement.width/heightが更新される | E-02 (193-194行目: domElement.width/height設定) | ○ |
| C-08 | setSize()でsetViewport()が呼び出される | E-02 (203行目: `this.setViewport( 0, 0, width, height )`) | ○ |
| C-09 | setSize()のupdateStyle引数でstyle更新を制御 | E-02 (196-200行目: updateStyle === trueの分岐) | ○ |
| C-10 | _width, _heightプロパティが更新される | E-02 (190-191行目: `this._width = width; this._height = height`) | ○ |
| C-11 | setDrawingBufferSize()でpixelRatioも更新される | E-03 (167行目: `this._pixelRatio = pixelRatio`) | ○ |
| C-12 | 通知一覧でresizeは「イベント通知」カテゴリである | E-04 (11行目: カテゴリ="イベント通知") | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [x] _dispatchResize()内でresizeイベントが発火されていることを確認
- [x] setSize/setDrawingBufferSizeから_dispatchResize()が呼び出されていることを確認
- [x] XRプレゼンテーション中の早期リターンを確認
