---
generated_at: 2026-01-27 13:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-finished

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/animation/AnimationAction.js` 763-766行目 - finishedイベント発火（LoopOnce）
- E-02: `src/animation/AnimationAction.js` 816-819行目 - finishedイベント発火（LoopRepeat/PingPong）
- E-03: `src/animation/AnimationAction.js` 758-759行目 - clampWhenFinished/enabled制御
- E-04: `src/animation/AnimationAction.js` 809-810行目 - clampWhenFinished/enabled制御（反復時）
- E-05: `src/animation/AnimationMixer.js` 16行目 - EventDispatcher継承
- E-06: `src/core/EventDispatcher.js` 101-126行目 - dispatchEvent実装
- E-07: `src/animation/AnimationAction.js` 67行目 - loop プロパティ（デフォルトLoopRepeat）
- E-08: `src/animation/AnimationAction.js` 116行目 - repetitions プロパティ
- E-09: `src/animation/AnimationAction.js` 150行目 - clampWhenFinished プロパティ
- E-10: `src/animation/AnimationMixer.js` 676-696行目 - update()メソッド
- E-11: `src/animation/AnimationAction.js` 553-629行目 - _update()メソッド
- E-12: `src/animation/AnimationAction.js` 711-866行目 - _updateTime()メソッド
- E-13: `src/core/EventDispatcher.js` 31-48行目 - addEventListener実装
- E-14: `src/constants.js` - LoopOnce, LoopRepeat, LoopPingPong定数定義
- E-15: `docs/code-to-docs/通知一覧/通知一覧.csv` 12行目 - finished通知の定義
- E-16: `src/animation/AnimationAction.js` 729-768行目 - LoopOnce終了判定ロジック
- E-17: `src/animation/AnimationAction.js` 794-820行目 - 反復完了時の終了判定ロジック
- E-18: `src/core/EventDispatcher.js` 114行目 - リスナー配列のコピーによる安全な走査

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | finishedイベントはアニメーション終了時に発火する | E-01, E-02 | ○ |
| C-02 | イベントオブジェクトにはtype, action, directionが含まれる | E-01, E-02 | ○ |
| C-03 | LoopOnceモードで終端到達時にイベント発火 | E-01, E-16 | ○ |
| C-04 | LoopRepeat/PingPongモードでrepetitions消化時にイベント発火 | E-02, E-17 | ○ |
| C-05 | clampWhenFinished=trueでpaused=trueになる | E-03, E-04 | ○ |
| C-06 | clampWhenFinished=falseでenabled=falseになる | E-03, E-04 | ○ |
| C-07 | AnimationMixerはEventDispatcherを継承している | E-05 | ○ |
| C-08 | dispatchEventでリスナーが同期的に呼び出される | E-06 | ○ |
| C-09 | イベントリスナーは登録順に呼び出される | E-06 | ○ |
| C-10 | loopプロパティのデフォルトはLoopRepeat | E-07 | ○ |
| C-11 | repetitionsプロパティのデフォルトはInfinity | E-08 | ○ |
| C-12 | AnimationMixer.update()がアクションを更新する | E-10 | ○ |
| C-13 | _updateTime()内で終了判定とイベント発火が行われる | E-12 | ○ |
| C-14 | directionは deltaTime > 0 で 1、それ以外で -1 | E-01, E-02 | ○ |
| C-15 | リスナー配列はコピーされてから走査される | E-18 | ○ |
| C-16 | addEventListenerでイベントリスナーを登録できる | E-13 | ○ |
| C-17 | 通知一覧.csvでfinishedイベントが定義されている | E-15 | ○ |
| C-18 | イベント発火前にenabled/pausedが設定される | E-03, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）

- [ ] finishedイベントの発火タイミングが正確に記述されているか確認
- [ ] イベントオブジェクトのプロパティ（type, action, direction）が正しいか確認
- [ ] clampWhenFinishedの動作説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
