---
generated_at: 2026-01-27 13:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-loop

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/animation/AnimationAction.js` 842-844行目 - loopイベント発火
- E-02: `src/animation/AnimationAction.js` 798-801行目 - loopDelta計算とtime調整
- E-03: `src/animation/AnimationAction.js` 67行目 - loop プロパティ（デフォルトLoopRepeat）
- E-04: `src/animation/AnimationAction.js` 68行目 - _loopCount初期値（-1）
- E-05: `src/animation/AnimationAction.js` 116行目 - repetitions プロパティ（デフォルトInfinity）
- E-06: `src/animation/AnimationAction.js` 770-792行目 - ループモード初期化処理
- E-07: `src/animation/AnimationAction.js` 794-846行目 - ループ境界処理全体
- E-08: `src/animation/AnimationAction.js` 803-820行目 - repetitions消化判定
- E-09: `src/animation/AnimationMixer.js` 16行目 - EventDispatcher継承
- E-10: `src/core/EventDispatcher.js` 101-126行目 - dispatchEvent実装
- E-11: `src/animation/AnimationAction.js` 719行目 - LoopPingPong判定
- E-12: `src/animation/AnimationAction.js` 854-860行目 - PingPong時の時間反転
- E-13: `src/constants.js` - LoopOnce, LoopRepeat, LoopPingPong定数定義
- E-14: `docs/code-to-docs/通知一覧/通知一覧.csv` 13行目 - loop通知の定義
- E-15: `src/animation/AnimationAction.js` 838行目 - _loopCount更新
- E-16: `src/animation/AnimationMixer.js` 690-696行目 - アクションの_update呼び出し

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | loopイベントはループ境界を跨ぐ際に発火する | E-01, E-07 | ○ |
| C-02 | イベントオブジェクトにはtype, action, loopDeltaが含まれる | E-01 | ○ |
| C-03 | loopDeltaはMath.floor(time / duration)で計算される | E-02 | ○ |
| C-04 | loopプロパティのデフォルトはLoopRepeat | E-03 | ○ |
| C-05 | _loopCountは-1で初期化される | E-04 | ○ |
| C-06 | repetitionsのデフォルトはInfinity | E-05 | ○ |
| C-07 | LoopOnceモードではloopイベントは発火しない | E-06, E-13 | ○ |
| C-08 | repetitions消化時はfinishedイベントが発火する | E-08 | ○ |
| C-09 | AnimationMixerはEventDispatcherを継承している | E-09 | ○ |
| C-10 | dispatchEventでリスナーが同期的に呼び出される | E-10 | ○ |
| C-11 | LoopPingPongモードでは再生方向が反転する | E-11, E-12 | ○ |
| C-12 | 通知一覧.csvでloopイベントが定義されている | E-14 | ○ |
| C-13 | イベント発火前に_loopCountが更新される | E-15, E-01 | ○ |
| C-14 | AnimationMixer.update()がアクションを更新する | E-16 | ○ |
| C-15 | 大きなdeltaTimeで複数ループをスキップする可能性がある | E-02 | ○ |
| C-16 | ループ継続判定はrepetitions - loopCount > 0で行われる | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）

- [ ] loopイベントの発火タイミングが正確に記述されているか確認
- [ ] loopDeltaの計算ロジックが正しいか確認
- [ ] LoopPingPongモードの動作説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
