---
generated_at: 2026-01-27 13:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-change

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/nodes/code/ScriptableValueNode.js` 106行目 - changeイベント発火
- E-02: `src/nodes/code/ScriptableValueNode.js` 92-110行目 - valueセッター全体
- E-03: `src/nodes/code/ScriptableValueNode.js` 94行目 - 値の同一性チェック
- E-04: `src/nodes/code/ScriptableValueNode.js` 96-101行目 - URLキャッシュクリーンアップ
- E-05: `src/nodes/code/ScriptableValueNode.js` 66行目 - eventsプロパティ（EventDispatcher）
- E-06: `src/nodes/code/ScriptableValueNode.js` 35行目 - _valueプロパティ
- E-07: `src/nodes/code/ScriptableValueNode.js` 43行目 - _cacheプロパティ
- E-08: `src/nodes/code/ScriptableValueNode.js` 108行目 - refresh()呼び出し
- E-09: `src/nodes/code/ScriptableValueNode.js` 126-130行目 - refresh()メソッド定義
- E-10: `src/core/EventDispatcher.js` 101-126行目 - dispatchEvent実装
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 14行目 - change通知の定義
- E-12: `src/nodes/code/ScriptableValueNode.js` 12行目 - Nodeクラス継承
- E-13: `src/nodes/code/ScriptableValueNode.js` 51行目 - inputTypeプロパティ
- E-14: `src/nodes/code/ScriptableValueNode.js` 104行目 - _value更新

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | changeイベントはvalueセッターで値変更時に発火する | E-01, E-02 | ○ |
| C-02 | イベントオブジェクトにはtypeのみが含まれる | E-01 | ○ |
| C-03 | 値が同一の場合はイベントが発火しない | E-03 | ○ |
| C-04 | inputType='URL'でキャッシュがある場合はURLが解放される | E-04 | ○ |
| C-05 | eventsプロパティはEventDispatcherインスタンスである | E-05 | ○ |
| C-06 | _valueはプライベートプロパティで値を保持する | E-06 | ○ |
| C-07 | _cacheはURLキャッシュを保持する | E-07 | ○ |
| C-08 | changeイベント後にrefresh()が呼び出される | E-08 | ○ |
| C-09 | refresh()メソッドはrefreshイベントを発火する | E-09 | ○ |
| C-10 | dispatchEventでリスナーが同期的に呼び出される | E-10 | ○ |
| C-11 | 通知一覧.csvでchangeイベントが定義されている | E-11 | ○ |
| C-12 | ScriptableValueNodeはNodeを継承している | E-12 | ○ |
| C-13 | inputTypeプロパティで入力タイプを管理する | E-13 | ○ |
| C-14 | 値の更新は_valueプロパティへの代入で行われる | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）

- [ ] changeイベントの発火条件が正確に記述されているか確認
- [ ] URLキャッシュクリーンアップの動作説明が正確か確認
- [ ] changeイベントとrefreshイベントの発火順序が正しいか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
