---
generated_at: 2026-01-27 13:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-refresh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/nodes/code/ScriptableValueNode.js` 126-130行目 - refresh()メソッド定義
- E-02: `src/nodes/code/ScriptableValueNode.js` 128行目 - refreshイベント発火
- E-03: `src/nodes/code/ScriptableValueNode.js` 108行目 - valueセッターからのrefresh()呼び出し
- E-04: `src/nodes/code/ScriptableValueNode.js` 66行目 - eventsプロパティ（EventDispatcher）
- E-05: `src/core/EventDispatcher.js` 101-126行目 - dispatchEvent実装
- E-06: `src/nodes/code/ScriptableValueNode.js` 106行目 - changeイベント発火（refresh前）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 15行目 - refresh通知の定義
- E-08: `src/nodes/code/ScriptableValueNode.js` 92-110行目 - valueセッター全体
- E-09: `src/core/EventDispatcher.js` 31-48行目 - addEventListener実装
- E-10: `src/nodes/code/ScriptableValueNode.js` 12行目 - Nodeクラス継承
- E-11: `src/nodes/code/ScriptableValueNode.js` 123-130行目 - refresh()メソッドのJSDoc
- E-12: `src/core/EventDispatcher.js` 114行目 - リスナー配列のコピーによる安全な走査

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | refreshイベントはrefresh()メソッド呼び出し時に発火する | E-01, E-02 | ○ |
| C-02 | イベントオブジェクトにはtypeのみが含まれる | E-02 | ○ |
| C-03 | valueセッター完了後にrefresh()が自動呼び出しされる | E-03 | ○ |
| C-04 | eventsプロパティはEventDispatcherインスタンスである | E-04 | ○ |
| C-05 | dispatchEventでリスナーが同期的に呼び出される | E-05 | ○ |
| C-06 | changeイベントの後にrefreshイベントが発火する | E-06, E-03 | ○ |
| C-07 | 通知一覧.csvでrefreshイベントが定義されている | E-07 | ○ |
| C-08 | refresh()は外部から直接呼び出し可能である | E-01 | ○ |
| C-09 | addEventListenerでイベントリスナーを登録できる | E-09 | ○ |
| C-10 | ScriptableValueNodeはNodeを継承している | E-10 | ○ |
| C-11 | refresh()メソッドは「Dispatches the refresh event」と文書化されている | E-11 | ○ |
| C-12 | リスナー配列はコピーされてから走査される | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）

- [ ] refreshイベントの発火タイミングが正確に記述されているか確認
- [ ] changeイベントとrefreshイベントの発火順序が正しいか確認
- [ ] 外部からの直接呼び出し時の動作説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
