---
generated_at: 2026-01-27 13:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-warnOnce

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/utils.js` 282-292行目 - warnOnce関数定義
- E-02: `src/utils.js` 284行目 - メッセージ結合（params.join(' ')）
- E-03: `src/utils.js` 286行目 - キャッシュ存在チェックと早期リターン
- E-04: `src/utils.js` 288行目 - キャッシュへの追加
- E-05: `src/utils.js` 290行目 - warn関数呼び出し
- E-06: `src/utils.js` 158行目 - _cache変数定義
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 19行目 - warnOnce通知の定義
- E-08: `src/utils.js` 273-281行目 - warnOnce関数のJSDoc
- E-09: `src/utils.js` 396行目 - export文（warnOnce関数のエクスポート）
- E-10: `src/utils.js` 231-245行目 - warn関数（warnOnceから呼び出し）
- E-11: `src/Three.Core.js` - utilsのエクスポート
- E-12: `src/utils.js` 152-158行目 - _cache変数のJSDocコメント
- E-13: `src/utils.js` 280行目 - JSDocに「only output each unique warning message once」と記載
- E-14: `src/utils.js` 277-279行目 - JSDocに重複警告防止の目的が記載

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | warnOnce関数は同一メッセージを1回のみ出力する | E-01, E-03, E-13 | ○ |
| C-02 | メッセージはparams.join(' ')で結合される | E-02 | ○ |
| C-03 | キャッシュに存在する場合は早期リターンする | E-03 | ○ |
| C-04 | キャッシュに存在しない場合はキャッシュに追加する | E-04 | ○ |
| C-05 | 内部的にwarn関数を呼び出す | E-05 | ○ |
| C-06 | _cache変数でメッセージをキャッシュする | E-06 | ○ |
| C-07 | 通知一覧.csvでwarnOnce通知が定義されている | E-07 | ○ |
| C-08 | キャッシュはオブジェクト形式で管理される | E-06, E-12 | ○ |
| C-09 | キャッシュのクリア機能はない | E-06（関連コードなし） | ○ |
| C-10 | warnOnce関数はexportされている | E-09 | ○ |
| C-11 | 重複警告防止が目的である | E-14 | ○ |
| C-12 | warn関数経由でコンソールに出力される | E-05, E-10 | ○ |
| C-13 | in演算子でキャッシュの存在を確認する | E-03 | ○ |
| C-14 | キャッシュ追加時は値をtrueに設定する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）

- [ ] warnOnce関数の重複防止ロジックが正確に記述されているか確認
- [ ] キャッシュの動作が正しいか確認
- [ ] warn関数との連携が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
