---
generated_at: 2026-01-27 13:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-onStart

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/loaders/LoadingManager.js` 86-102行目 - itemStart()メソッド定義
- E-02: `src/loaders/LoadingManager.js` 88行目 - itemsTotal++
- E-03: `src/loaders/LoadingManager.js` 90行目 - isLoading === false チェック
- E-04: `src/loaders/LoadingManager.js` 92-96行目 - onStartコールバック呼び出し
- E-05: `src/loaders/LoadingManager.js` 94行目 - onStart(url, itemsLoaded, itemsTotal)
- E-06: `src/loaders/LoadingManager.js` 100行目 - isLoading = true
- E-07: `src/loaders/LoadingManager.js` 31-33行目 - isLoading, itemsLoaded, itemsTotal変数
- E-08: `src/loaders/LoadingManager.js` 46行目 - onStartプロパティ定義
- E-09: `src/loaders/LoadingManager.js` 37-38行目 - コンストラクタでonStartを設定しない理由のコメント
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 20行目 - onStart通知の定義
- E-11: `src/loaders/LoadingManager.js` 40-46行目 - onStartプロパティのJSDoc
- E-12: `src/loaders/LoadingManager.js` 120-122行目 - itemsLoaded === itemsTotal時にisLoadingをfalseに
- E-13: `src/loaders/LoadingManager.js` 18-26行目 - コンストラクタ定義
- E-14: `src/loaders/Loader.js` - ローダー基底クラス（LoadingManagerを使用）
- E-15: `src/loaders/LoadingManager.js` 81-85行目 - itemStart()のJSDoc
- E-16: `src/loaders/LoadingManager.js` 32-33行目 - itemsLoaded=0, itemsTotal=0 初期値

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onStartはitemStart()メソッドから呼び出される | E-01, E-04 | ○ |
| C-02 | isLoading === false の場合のみonStartが呼び出される | E-03 | ○ |
| C-03 | onStart !== undefined の場合のみ呼び出される | E-04 | ○ |
| C-04 | コールバックにはurl, itemsLoaded, itemsTotalが渡される | E-05 | ○ |
| C-05 | itemStart()呼び出しでitemsTotal++される | E-02 | ○ |
| C-06 | onStart呼び出し後にisLoading = trueに設定される | E-06 | ○ |
| C-07 | isLoading, itemsLoaded, itemsTotalはローカル変数として管理される | E-07 | ○ |
| C-08 | onStartはコンストラクタで設定できない | E-09 | ○ |
| C-09 | 通知一覧.csvでonStart通知が定義されている | E-10 | ○ |
| C-10 | onStartプロパティはundefinedがデフォルト | E-08 | ○ |
| C-11 | 読み込み完了時にisLoadingがfalseに戻る | E-12 | ○ |
| C-12 | itemsLoadedの初期値は0 | E-16 | ○ |
| C-13 | itemsTotalの初期値は0 | E-16 | ○ |
| C-14 | 読み込みセッション中に新しいアイテムが追加されてもonStartは1回のみ | E-03, E-06 | ○ |
| C-15 | onStartはローディングUI表示の開始に使用される | E-11 | ○ |
| C-16 | 引数urlはitemStart()の引数から取得される | E-05, E-15 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）

- [ ] onStartコールバックの発火条件が正確に記述されているか確認
- [ ] コールバック引数（url, itemsLoaded, itemsTotal）が正しいか確認
- [ ] isLoadingフラグの動作説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
