---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-connected.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/renderers/webxr/WebXRController.js` 156-179行目 connect()メソッド
- E-02: `src/renderers/webxr/WebXRController.js` 126-148行目 dispatchEvent()メソッド
- E-03: `src/renderers/webxr/WebXRManager.js` 550-614行目 onInputSourcesChange()関数
- E-04: `src/renderers/webxr/WebXRController.js` 27-48行目 _targetRay, _grip, _hand定義
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 3行目 connected通知の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | connectedイベントはWebXRController.connect()で発火される | E-01 (175行目: `this.dispatchEvent( { type: 'connected', data: inputSource } )`) | ○ |
| C-02 | イベントオブジェクトにはdataプロパティがありXRInputSourceを含む | E-01 (175行目: `data: inputSource`) | ○ |
| C-03 | dispatchEventは_targetRay、_grip、_handに順次イベントを送信する | E-02 (128-144行目: 3つのGroupに対する送信処理) | ○ |
| C-04 | _targetRayがnullの場合はスキップされる | E-02 (128行目: `if ( this._targetRay !== null )`) | ○ |
| C-05 | _gripがnullの場合はスキップされる | E-02 (134行目: `if ( this._grip !== null )`) | ○ |
| C-06 | _handがnullの場合はスキップされる | E-02 (140行目: `if ( this._hand !== null )`) | ○ |
| C-07 | inputsourceschangeイベントでconnectが呼び出される | E-03 (604-610行目: `controller.connect( inputSource )`) | ○ |
| C-08 | event.addedに含まれる入力ソースに対して処理される | E-03 (570行目: `for ( let i = 0; i < event.added.length; i ++ )`) | ○ |
| C-09 | handモード時にjointsが初期化される | E-01 (158-173行目: hand.jointsの初期化処理) | ○ |
| C-10 | inputSource.handが存在する場合にjoints初期化が実行される | E-01 (158行目: `if ( inputSource && inputSource.hand )`) | ○ |
| C-11 | _getHandJointでjointが初期化される | E-01 (167行目: `this._getHandJoint( hand, inputjoint )`) | ○ |
| C-12 | WebXRControllerクラスは座標空間を管理する | E-04 (_targetRay, _grip, _handの定義) | ○ |
| C-13 | 通知一覧でconnectedは「イベント通知」カテゴリである | E-05 (3行目: カテゴリ="イベント通知") | ○ |
| C-14 | 通知一覧でconnectedはdataプロパティにinputSourceを含むと記載 | E-05 (3行目: "dataプロパティにinputSourceを含む") | ○ |
| C-15 | connect()は接続後にthisを返す | E-01 (177行目: `return this`) | ○ |
| C-16 | getHandSpaceでjointsオブジェクトが初期化される | E-04 (64行目: `this._hand.joints = {}`) | ○ |
| C-17 | getHandSpaceでinputStateが初期化される | E-04 (65行目: `this._hand.inputState = { pinching: false }`) | ○ |
| C-18 | WebXRControllerはEventDispatcherを継承していない（独自dispatchEvent実装） | E-02 (126-148行目: 独自のdispatchEventメソッド実装) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に対してソースコードから根拠を確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] connect()メソッドがconnectedイベントを発火していることを確認
- [x] dispatchEventが3つの座標空間に対して送信することを確認
- [x] 通知一覧.csvとの整合性を確認
