---
generated_at: 2026-01-27 13:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-onProgress

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/loaders/LoadingManager.js` 110-132行目 - itemEnd()メソッド定義
- E-02: `src/loaders/LoadingManager.js` 112行目 - itemsLoaded++
- E-03: `src/loaders/LoadingManager.js` 114-118行目 - onProgressコールバック呼び出し
- E-04: `src/loaders/LoadingManager.js` 116行目 - onProgress(url, itemsLoaded, itemsTotal)
- E-05: `src/loaders/LoadingManager.js` 120-122行目 - itemsLoaded === itemsTotal時の処理
- E-06: `src/loaders/LoadingManager.js` 124-128行目 - onLoad呼び出し
- E-07: `src/loaders/LoadingManager.js` 31-33行目 - isLoading, itemsLoaded, itemsTotal変数
- E-08: `src/loaders/LoadingManager.js` 62行目 - onProgressプロパティ定義
- E-09: `src/loaders/LoadingManager.js` 27行目 - コンストラクタでonProgress引数を受け取る
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 21行目 - onProgress通知の定義
- E-11: `src/loaders/LoadingManager.js` 56-62行目 - onProgressプロパティのJSDoc
- E-12: `src/loaders/LoadingManager.js` 104-109行目 - itemEnd()のJSDoc
- E-13: `src/loaders/Loader.js` - ローダー基底クラス（LoadingManagerを使用）
- E-14: `src/loaders/LoadingManager.js` 120行目 - isLoading = false
- E-15: `src/loaders/LoadingManager.js` 18-26行目 - コンストラクタ定義
- E-16: `src/loaders/LoadingManager.js` 122行目 - 全アイテム完了判定

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onProgressはitemEnd()メソッドから呼び出される | E-01, E-03 | ○ |
| C-02 | onProgress !== undefined の場合のみ呼び出される | E-03 | ○ |
| C-03 | コールバックにはurl, itemsLoaded, itemsTotalが渡される | E-04 | ○ |
| C-04 | itemEnd()呼び出しでitemsLoaded++される | E-02 | ○ |
| C-05 | itemsLoaded === itemsTotal時にisLoading = falseになる | E-05, E-14 | ○ |
| C-06 | 全アイテム完了時にonLoadも呼び出される | E-06 | ○ |
| C-07 | isLoading, itemsLoaded, itemsTotalはローカル変数として管理される | E-07 | ○ |
| C-08 | 通知一覧.csvでonProgress通知が定義されている | E-10 | ○ |
| C-09 | onProgressはコンストラクタの第2引数として設定可能 | E-09, E-15 | ○ |
| C-10 | onProgressプロパティとしても設定可能 | E-08 | ○ |
| C-11 | 各アイテムの完了ごとにonProgressが呼び出される | E-01, E-03 | ○ |
| C-12 | itemsLoaded / itemsTotal で進捗率を計算可能 | E-04, E-11 | ○ |
| C-13 | 最後のアイテム完了時はonProgress後にonLoadが呼び出される | E-03, E-06, E-16 | ○ |
| C-14 | itemsLoadedはインクリメント後の値がコールバックに渡される | E-02, E-03 | ○ |
| C-15 | onProgress呼び出し前にitemsLoadedがインクリメントされる | E-02, E-03 | ○ |
| C-16 | urlはitemEnd()の引数から取得される | E-04, E-12 | ○ |

## 4) 不足情報（Unknown / Missing）

なし。すべての主張に対してソースコードから根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）

- [ ] onProgressコールバックの発火条件が正確に記述されているか確認
- [ ] コールバック引数（url, itemsLoaded, itemsTotal）が正しいか確認
- [ ] itemsLoaded のインクリメントタイミングが正しいか確認
- [ ] 全アイテム完了時のonLoad呼び出しが正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致するか確認
