---
generated_at: 2026-01-27 12:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-onLoad

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Issue #5689の参照**：GitHubリポジトリへのアクセスなしのため未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/loaders/LoadingManager.js` - LoadingManagerクラスの実装
- E-02: `src/loaders/FileLoader.js` - FileLoaderクラスの実装
- E-03: `src/loaders/Loader.js` - Loaderベースクラスの実装
- E-04: `test/unit/src/loaders/LoadingManager.tests.js` - LoadingManagerの単体テスト
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onLoadは全アイテム読み込み完了時に呼ばれる | E-01 (120-128行目) | ○ |
| C-02 | コンストラクタ第一引数でonLoadを設定可能 | E-01 (27, 54行目) | ○ |
| C-03 | onLoadプロパティに直接代入で設定可能 | E-01 (48-54行目) | ○ |
| C-04 | onLoadコールバックは引数を持たない | E-01 (126行目: `scope.onLoad()`) | ○ |
| C-05 | itemsLoaded === itemsTotal で発火 | E-01 (120行目) | ○ |
| C-06 | isLoadingがfalseに設定される | E-01 (122行目) | ○ |
| C-07 | onLoadがundefinedの場合は呼ばれない | E-01 (124行目: `if (scope.onLoad !== undefined)`) | ○ |
| C-08 | FileLoaderはfinallyでitemEnd()を呼ぶ | E-02 (315-318行目) | ○ |
| C-09 | FileLoaderはitemStart()を呼ぶ | E-02 (321行目) | ○ |
| C-10 | 送信方式は同期である | E-01 (126行目: 直接関数呼び出し) | ○ |
| C-11 | DefaultLoadingManagerが存在する | E-01 (327行目) | ○ |
| C-12 | Loaderクラスはmanagerプロパティを持つ | E-03 (23行目) | ○ |
| C-13 | DefaultLoadingManagerがデフォルトで使用される | E-03 (23行目) | ○ |
| C-14 | onStartはコンストラクタで設定されない | E-01 (37-38行目: コメント参照) | ○ |
| C-15 | Issue #5689がonStartの理由 | **根拠なし** | △ |
| C-16 | itemsLoaded変数が内部で管理される | E-01 (32行目) | ○ |
| C-17 | itemsTotal変数が内部で管理される | E-01 (33行目) | ○ |
| C-18 | onProgressはonLoadの前に呼ばれる | E-01 (114-117行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **Issue #5689の内容確認**：GitHubの当該Issueへのアクセスができないため、onStartがコンストラクタで設定されない理由の詳細は未検証
  - 候補：GitHubリポジトリ / three.js公式ドキュメント / コード内コメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 0: 低リスク - コールバックのシグネチャは実装と一致
- 1: 中リスク - Issue #5689への参照は外部情報源のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] LoadingManager.jsの120-128行目でonLoad呼び出しロジックが正しく説明されているか確認
- [ ] FileLoader.jsのitemStart/itemEnd呼び出しタイミングが正しいか確認
- [ ] Issue #5689の内容を確認し、onStartに関する備考が正確か検証（オプション）
- [ ] 処理フロー図がコードの実際の流れと一致しているか確認
