---
generated_at: 2026-01-27 12:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-onError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張にソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/loaders/LoadingManager.js` - LoadingManagerクラスの実装
- E-02: `src/loaders/FileLoader.js` - FileLoaderクラスの実装（HttpErrorクラス含む）
- E-03: `src/loaders/Loader.js` - Loaderベースクラスの実装
- E-04: `test/unit/src/loaders/LoadingManager.tests.js` - LoadingManagerの単体テスト
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onErrorはエラー発生時に呼ばれる | E-01 (140-147行目) | ○ |
| C-02 | コンストラクタ第三引数でonErrorを設定可能 | E-01 (27, 70行目) | ○ |
| C-03 | onErrorプロパティに直接代入で設定可能 | E-01 (64-70行目) | ○ |
| C-04 | onErrorコールバックはurlを引数に持つ | E-01 (144行目: `scope.onError(url)`) | ○ |
| C-05 | itemError()メソッドがonErrorを呼ぶ | E-01 (140-147行目) | ○ |
| C-06 | onErrorがundefinedの場合は呼ばれない | E-01 (142行目: `if (scope.onError !== undefined)`) | ○ |
| C-07 | FileLoaderはcatch節でitemError()を呼ぶ | E-02 (312行目) | ○ |
| C-08 | HttpErrorクラスが存在する | E-02 (7-16行目) | ○ |
| C-09 | HttpErrorはresponseプロパティを持つ | E-02 (11行目) | ○ |
| C-10 | 非成功HTTPステータスでHttpErrorがスローされる | E-02 (221行目) | ○ |
| C-11 | 送信方式は同期である | E-01 (144行目: 直接関数呼び出し) | ○ |
| C-12 | 個別onErrorが先に実行される | E-02 (305-309行目) | ○ |
| C-13 | 個別onErrorの後にmanager.itemErrorが呼ばれる | E-02 (305-312行目の順序) | ○ |
| C-14 | エラー発生後もitemEnd()は呼ばれる | E-02 (315-318行目: finally節) | ○ |
| C-15 | AbortControllerによる中断もエラーとして扱われる | E-02 (289-291行目: コメント) | ○ |
| C-16 | HTTPステータス200と0は成功扱い | E-02 (145-154行目) | ○ |
| C-17 | ステータス0は非httpプロトコル用 | E-02 (147-148行目: コメント) | ○ |
| C-18 | LoadingManager自体はリトライしない | E-01 (140-147行目: リトライロジックなし) | ○ |
| C-19 | onErrorCallbackの型定義が存在する | E-03 (203-208行目) | ○ |
| C-20 | エラー時はキャッシュされない | E-02 (276行目: 成功時のみCache.add) | ○ |
| C-21 | duplicateリクエストのcallbacks全てにonError通知 | E-02 (305-309行目: forループ) | ○ |
| C-22 | callbacksがundefinedの場合の処理 | E-02 (295-300行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードにより検証済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の説明は全てソースコードで検証済み
- 0: 低リスク - コールバックのシグネチャは実装と一致
- 0: 低リスク - エラーハンドリングフローは実装と一致

## 6) レビュアーチェックリスト（最小）
- [ ] LoadingManager.jsの140-147行目でitemError()実装が正しく説明されているか確認
- [ ] FileLoader.jsのcatch節（289-314行目）でのエラー処理順序が正しいか確認
- [ ] HttpErrorクラスの説明がFileLoader.js 7-16行目と一致しているか確認
- [ ] 処理フロー図がコードの実際の流れと一致しているか確認
- [ ] finally節でのitemEnd()呼び出しが正しく説明されているか確認
