---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-disconnected.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/renderers/webxr/WebXRController.js` 187-211行目 disconnect()メソッド
- E-02: `src/renderers/webxr/WebXRManager.js` 553-566行目 onInputSourcesChange内removed処理
- E-03: `src/renderers/webxr/WebXRManager.js` 224-234行目 onSessionEnd内disconnect処理
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 4行目 disconnected通知の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | disconnectedイベントはWebXRController.disconnect()で発火される | E-01 (189行目: `this.dispatchEvent( { type: 'disconnected', data: inputSource } )`) | ○ |
| C-02 | イベントオブジェクトにはdataプロパティがありXRInputSourceを含む | E-01 (189行目: `data: inputSource`) | ○ |
| C-03 | disconnect後に_targetRay.visibleがfalseに設定される | E-01 (193行目: `this._targetRay.visible = false`) | ○ |
| C-04 | disconnect後に_grip.visibleがfalseに設定される | E-01 (199行目: `this._grip.visible = false`) | ○ |
| C-05 | disconnect後に_hand.visibleがfalseに設定される | E-01 (205行目: `this._hand.visible = false`) | ○ |
| C-06 | inputsourceschangeのevent.removedでdisconnectが呼び出される | E-02 (562行目: `controllers[ index ].disconnect( inputSource )`) | ○ |
| C-07 | セッション終了時に全コントローラーにdisconnectが呼び出される | E-03 (232行目: `controllers[ i ].disconnect( inputSource )`) | ○ |
| C-08 | _targetRayがnullでない場合にvisible設定される | E-01 (191行目: `if ( this._targetRay !== null )`) | ○ |
| C-09 | _gripがnullでない場合にvisible設定される | E-01 (197行目: `if ( this._grip !== null )`) | ○ |
| C-10 | _handがnullでない場合にvisible設定される | E-01 (203行目: `if ( this._hand !== null )`) | ○ |
| C-11 | 通知一覧でdisconnectedは「イベント通知」カテゴリである | E-04 (4行目: カテゴリ="イベント通知") | ○ |
| C-12 | 通知一覧でdisconnectedはdataプロパティにinputSourceを含むと記載 | E-04 (4行目: "dataプロパティにinputSourceを含む") | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [x] disconnect()メソッドがdisconnectedイベントを発火していることを確認
- [x] visible=false設定が実装されていることを確認
