---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-move.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/renderers/webxr/WebXRController.js` 4行目 _moveEvent定義
- E-02: `src/renderers/webxr/WebXRController.js` 223-396行目 update()メソッド
- E-03: `src/renderers/webxr/WebXRController.js` 369行目 dispatchEvent呼び出し
- E-04: `src/renderers/webxr/WebXRManager.js` 1062-1073行目 onAnimationFrame内update呼び出し
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 5行目 move通知の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | moveイベントは_moveEventとして事前定義されている | E-01 (4行目: `const _moveEvent = { type: 'move' }`) | ○ |
| C-02 | moveイベントはupdate()メソッド内で発火される | E-03 (369行目: `this.dispatchEvent( _moveEvent )`) | ○ |
| C-03 | visibilityStateがvisible-blurredの場合は処理スキップ | E-02 (233行目: `frame.session.visibilityState !== 'visible-blurred'`) | ○ |
| C-04 | inputPoseがnullでない場合にイベント発火 | E-02 (341行目: `if ( inputPose !== null )`) | ○ |
| C-05 | targetRayのmatrixがinputPoseから更新される | E-02 (343行目: `targetRay.matrix.fromArray( inputPose.transform.matrix )`) | ○ |
| C-06 | handモードではmoveイベントは発火しない | E-02 (235-288行目: handモード処理にはdispatchEvent無し、290行目からelse分岐) | ○ |
| C-07 | onAnimationFrameからcontroller.updateが呼び出される | E-04 (1069行目: `controller.update( inputSource, frame, ... )`) | ○ |
| C-08 | イベントオブジェクトにはtypeのみ含まれる | E-01 (`{ type: 'move' }`のみ) | ○ |
| C-09 | 通知一覧でmoveは「イベント通知」カテゴリである | E-05 (5行目: カテゴリ="イベント通知") | ○ |
| C-10 | moveイベントは毎フレーム発火される | E-02, E-04 (フレームループ内でupdate→dispatchEvent) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [x] _moveEventの定義を確認
- [x] update()メソッドでdispatchEventが呼び出されていることを確認
