---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-pinchstart.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/renderers/webxr/WebXRController.js` 260-288行目 ピンチ検出処理
- E-02: `src/renderers/webxr/WebXRController.js` 65行目 inputState初期化
- E-03: `src/renderers/webxr/WebXRController.js` 263行目 indexTip取得
- E-04: `src/renderers/webxr/WebXRController.js` 264行目 thumbTip取得
- E-05: `src/renderers/webxr/WebXRController.js` 267-268行目 閾値定義
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 6行目 pinchstart通知の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pinchstartはハンドトラッキング時にピンチ開始で発火 | E-01 (279-287行目: ピンチ開始判定とイベント発火) | ○ |
| C-02 | indexTipはhand.joints['index-finger-tip']から取得 | E-03 (263行目: `hand.joints[ 'index-finger-tip' ]`) | ○ |
| C-03 | thumbTipはhand.joints['thumb-tip']から取得 | E-04 (264行目: `hand.joints[ 'thumb-tip' ]`) | ○ |
| C-04 | distanceToPinchは0.02 | E-05 (267行目: `const distanceToPinch = 0.02`) | ○ |
| C-05 | thresholdは0.005 | E-05 (268行目: `const threshold = 0.005`) | ○ |
| C-06 | ピンチ開始条件はdistance <= distanceToPinch - threshold | E-01 (279行目: `distance <= distanceToPinch - threshold`) | ○ |
| C-07 | pinching状態がfalseの時のみイベント発火 | E-01 (279行目: `! hand.inputState.pinching &&`) | ○ |
| C-08 | イベント発火前にinputState.pinchingをtrueに設定 | E-01 (281行目: `hand.inputState.pinching = true`) | ○ |
| C-09 | イベントオブジェクトにhandednessが含まれる | E-01 (284行目: `handedness: inputSource.handedness`) | ○ |
| C-10 | イベントオブジェクトにtargetとしてthisが含まれる | E-01 (285行目: `target: this`) | ○ |
| C-11 | inputStateは初期状態でpinching: falseを持つ | E-02 (65行目: `this._hand.inputState = { pinching: false }`) | ○ |
| C-12 | 通知一覧でpinchstartは「イベント通知」カテゴリである | E-06 (6行目: カテゴリ="イベント通知") | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [x] ピンチ検出ロジックの閾値を確認
- [x] イベントオブジェクトの構造を確認
