---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-planesdetected.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/renderers/webxr/WebXRManager.js` 1077-1081行目 planesdetected発火処理
- E-02: `src/renderers/webxr/WebXRManager.js` 916-1085行目 onAnimationFrame関数
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 10行目 planesdetected通知の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | planesdetectedはonAnimationFrame内で発火される | E-01 (1079行目: `scope.dispatchEvent( { type: 'planesdetected', data: frame } )`) | ○ |
| C-02 | イベントオブジェクトにdataプロパティが含まれる | E-01 (1079行目: `data: frame`) | ○ |
| C-03 | dataプロパティにはXRFrameが設定される | E-01 (1079行目: `data: frame`、frameはonAnimationFrameの引数) | ○ |
| C-04 | frame.detectedPlanesが存在する場合のみ発火 | E-01 (1077行目: `if ( frame.detectedPlanes )`) | ○ |
| C-05 | onAnimationFrameはXRフレームごとに呼び出される | E-02 (916行目: `function onAnimationFrame( time, frame )`) | ○ |
| C-06 | コントローラー更新後に平面検出イベントが発火される | E-02 (1062-1073行目: コントローラー更新、1077行目: planesdetected) | ○ |
| C-07 | onAnimationFrameCallback呼び出し後に発火される | E-02 (1075行目: callback呼び出し、1077行目: planesdetected) | ○ |
| C-08 | 通知一覧でplanesdetectedは「イベント通知」カテゴリである | E-03 (10行目: カテゴリ="イベント通知") | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [x] onAnimationFrame内でplanesdetectedイベントが発火されていることを確認
- [x] frame.detectedPlanesの存在チェックを確認
