---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **キーボードショートカット（W/E/R）**：ソースコード確認が望ましい
  2. **レンダリングオプション詳細**：Menubar.Render.jsの詳細確認が必要
  3. **Publish機能の詳細**：エクスポートオプションの完全な記述が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面構成
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能対応
- E-07: `docs/code-to-docs/画面設計書/1-エディタメイン画面.md` - メイン画面設計
- E-08: `docs/code-to-docs/画面設計書/2-Viewport.md` - Viewport設計
- E-09: `docs/code-to-docs/画面設計書/10-Menubar-File.md` - Fileメニュー設計
- E-10: `docs/code-to-docs/画面設計書/12-Menubar - Add.md` - Addメニュー設計

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | three.js Editorはブラウザ上で3Dグラフィックスを作成・編集するWebベースの3Dエディタ | E-01, E-07 | ○ |
| C-02 | システムはPWA対応でオフライン利用可能 | E-07 | ○ |
| C-03 | プロジェクトデータはIndexedDBに自動保存される | E-07 | ○ |
| C-04 | エディタ画面はMenubar、Toolbar、Viewport、Sidebar、Script Editor、Playerで構成 | E-02, E-03, E-07 | ○ |
| C-05 | File メニューからNew/Open/Save/Import/Export操作が可能 | E-09 | ○ |
| C-06 | Empty および5種類のサンプルプロジェクトが利用可能 | E-09 | ○ |
| C-07 | インポート対応フォーマットにGLTF/FBX/OBJ/STL等が含まれる | E-09, E-04 | ○ |
| C-08 | Add メニューから16種類のMeshが追加可能 | E-10 | ○ |
| C-09 | Add メニューから5種類のLightが追加可能 | E-10 | ○ |
| C-10 | Add メニューから2種類のCameraが追加可能 | E-10 | ○ |
| C-11 | オブジェクト選択はViewportでのクリックまたはシーン階層で可能 | E-08 | ○ |
| C-12 | TransformControlsで移動/回転/スケール操作が可能 | E-08 | ○ |
| C-13 | キーボードショートカット W/E/R で変形モード切替 | **根拠なし** | △ |
| C-14 | Sidebarからマテリアル編集が可能 | E-02, E-06 | ○ |
| C-15 | MeshStandardMaterial/MeshPhysicalMaterialでPBR表現が可能 | E-05, E-04 | ○ |
| C-16 | Sceneタブから背景/環境/フォグ設定が可能 | E-02, E-03 | ○ |
| C-17 | シェーディングモード切替（Solid/Wireframe/Normals/Realistic）が可能 | E-08 | ○ |
| C-18 | エクスポート対応フォーマット：GLB/GLTF/OBJ/STL/PLY/DRC/USDZ | E-09 | ○ |
| C-19 | GLBはシーン全体、OBJは選択オブジェクトのみエクスポート | E-09 | ○ |
| C-20 | マウス左ドラッグでカメラ回転 | E-08 | ○ |
| C-21 | マウス中/右ドラッグでカメラパン | E-08 | ○ |
| C-22 | スクロールでカメラズーム | E-08 | ○ |
| C-23 | ダブルクリックでオブジェクトフォーカス | E-08 | ○ |
| C-24 | Examples画面で217件のWebGLサンプルが閲覧可能 | E-02 | ○ |
| C-25 | Examples画面で194件のWebGPUサンプルが閲覧可能 | E-02 | ○ |
| C-26 | Documentation画面でAPIドキュメント参照可能 | E-02 | ○ |
| C-27 | Geometry/Material/Bones Browserでインタラクティブプレビュー可能 | E-02 | ○ |
| C-28 | Manual画面で6言語対応（en/fr/ru/ko/zh/ja） | E-02, E-03 | ○ |
| C-29 | 変更から1秒後に自動保存が実行される | E-07 | ○ |
| C-30 | ServiceWorkerでオフライン対応 | E-07 | ○ |
| C-31 | Renderメニューからレンダリング操作が可能 | E-02 | ○ |
| C-32 | レンダリングオプションの詳細設定 | **根拠なし** | △ |
| C-33 | Publish機能でスタンドアロンアプリ出力 | E-03 | ○ |
| C-34 | View Helperで視点切替が可能 | E-08 | ○ |
| C-35 | グリッドヘルパーは2層構造 | E-08 | ○ |
| C-36 | Undo/Redo機能がEdit メニューから利用可能 | E-02 | ○ |
| C-37 | パストレーサーモードはWebGLRenderer時のみ利用可能 | E-08 | ○ |
| C-38 | ファイルをViewportにドラッグ&ドロップでインポート可能 | E-07 | ○ |
| C-39 | GLTFインポート時にオプションダイアログ表示 | E-02 | ○ |
| C-40 | プロジェクト保存ファイル名はproject.json | E-09 | ○ |
| C-41 | 対応ブラウザはChrome/Edge/Safari/Firefox | E-07 | ○ |
| C-42 | WebGPU機能はChrome/Edgeを推奨 | E-01 | ○ |
| C-43 | 認証・認可機能は存在しない | E-07 | ○ |
| C-44 | スタンドアロンアプリはHTMLファイルと関連アセットで構成 | **根拠なし** | △ |
| C-45 | エクスポーターは動的インポートで必要時のみ読み込み | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **キーボードショートカット（C-13）**：Viewport.jsまたはToolbar.jsでのショートカット実装を確認する必要がある
  - 候補：editor/js/Viewport.js / editor/js/Toolbar.js / editor/js/Shortcuts.js
- **レンダリングオプション詳細（C-32）**：Menubar.Render.jsの詳細実装を確認する必要がある
  - 候補：editor/js/Menubar.Render.js
- **スタンドアロンアプリ構成（C-44）**：editor/js/libs/app/の構成を確認する必要がある
  - 候補：editor/js/libs/app/index.html

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：システム概要、画面構成、基本操作手順
- 0（低リスク）：ファイル操作（New/Open/Save/Import/Export）
- 0（低リスク）：オブジェクト追加・編集操作
- 1（中リスク）：キーボードショートカットの記述（ソースコード確認推奨）
- 1（中リスク）：レンダリング機能の詳細記述
- 1（中リスク）：Publish機能の詳細記述

## 6) レビュアーチェックリスト（最小）
- [ ] 1章「システム概要」の内容がREADME.mdおよびプロジェクト実態と一致しているか
- [ ] 4章「プロジェクト準備」の操作手順がMenubar.File.jsの実装と一致しているか
- [ ] 5章「オブジェクト編集」の操作手順がMenubar.Add.jsおよびViewport.jsの実装と一致しているか
- [ ] 7章「エクスポート」の対応フォーマット一覧がMenubar.File.jsの実装と一致しているか
- [ ] キーボードショートカット（W/E/R）が実際に動作するか確認
- [ ] スタンドアロンアプリのPublish機能が正常に動作するか確認
- [ ] 画面キャプチャ等のビジュアルエイドが必要かどうか検討
