# three.js Editor 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】プロジェクト準備（新規作成・読み込み）](#4-step1プロジェクト準備新規作成読み込み)
5. [【STEP2-3】3Dオブジェクト編集（追加・変形・マテリアル設定）](#5-step2-33dオブジェクト編集追加変形マテリアル設定)
6. [【STEP3-4】シーン設定（背景・環境・フォグ）](#6-step3-4シーン設定背景環境フォグ)
7. [【STEP4-5】エクスポート・公開](#7-step4-5エクスポート公開)

**【サポート機能】**
8. [Examples（サンプル）機能](#8-examplesサンプル機能)
9. [Documentation（ドキュメント）機能](#9-documentationドキュメント機能)
10. [Manual（マニュアル）機能](#10-manualマニュアル機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 three.js Editorとは

three.js Editorは、ブラウザ上で3Dグラフィックスを視覚的に作成・編集するためのWebベースの3Dエディタです。プログラミングの知識がなくても、直感的なGUI操作で3Dシーンを構築でき、WebGL/WebGPUアプリケーションとして出力することができます。

**主な特徴：**
- ブラウザのみで動作（インストール不要）
- オフライン対応（PWA）
- 多様な3Dフォーマットのインポート/エクスポート対応
- リアルタイムプレビュー
- VR/AR（WebXR）対応

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **3Dシーン作成** | 3Dオブジェクトの追加・配置、ライト・カメラの設定 |
| **モデル編集** | オブジェクトの移動・回転・スケール変形、マテリアル設定 |
| **アセット管理** | 外部3Dモデルのインポート、テクスチャの適用 |
| **プロジェクト管理** | プロジェクトの保存・読み込み、バージョン管理 |
| **コンテンツ出力** | 各種3Dフォーマットへのエクスポート、スタンドアロンアプリの公開 |

### 1.3 業務フロー概要

本システムにおける3Dコンテンツ制作業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                        業務フロー                                │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】プロジェクトの準備（新規作成または既存読み込み）      │
│      ↓                                                          │
│  【STEP 2】3Dオブジェクトの追加と配置                           │
│      ↓                                                          │
│  【STEP 3】オブジェクトの編集（変形、マテリアル設定）           │
│      ↓                                                          │
│  【STEP 4】シーン設定（背景、環境、フォグ）とプレビュー確認     │
│      ↓                                                          │
│  【STEP 5】エクスポートまたはスタンドアロンアプリとして公開     │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **3Dデザイナー** | シーン構築、オブジェクト配置、マテリアル設定、ライティング調整 |
| **開発者** | スクリプト追加、エクスポート設定、アプリケーション公開 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| プロジェクト管理 | 新規作成、開く、保存、サンプル読み込み | STEP 1 |
| オブジェクト追加 | メッシュ、ライト、カメラの追加 | STEP 2 |
| 変形操作 | 移動、回転、スケールの編集 | STEP 2-3 |
| マテリアル編集 | 色、テクスチャ、物理特性の設定 | STEP 3 |
| シーン設定 | 背景、環境マップ、フォグの設定 | STEP 4 |
| プレビュー | リアルタイム描画、再生テスト | STEP 4 |
| エクスポート | GLTF、OBJ、STL等への出力 | STEP 5 |
| インポート | 外部3Dモデルの読み込み | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 一般ユーザー | すべての機能にアクセス可能（認証なし） |

※ 本エディタはクライアントサイドのみで動作し、認証・認可機能は存在しません。

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）- WebGPU対応
- Microsoft Edge（最新版）- WebGPU対応
- Safari（最新版）
- Firefox（最新版）

※ WebGPU機能を使用する場合は、Chrome または Edge を推奨します。

---

## 2. ログイン・ログアウト手順

### 2.1 アクセス方法

three.js Editorは認証機能を持たないWebアプリケーションです。以下の手順でアクセスします。

1. ブラウザを起動します
2. three.js Editorの URL にアクセスします
   - ローカル開発環境: `http://localhost:8080/editor/`
   - 公式サイト: `https://threejs.org/editor/`
3. エディタ画面が表示されます

### 2.2 オフライン利用

本エディタはPWA（Progressive Web App）に対応しており、一度アクセスするとオフラインでも利用可能です。

1. 初回アクセス時に、ブラウザがServiceWorkerを登録します
2. 以降は、インターネット接続がなくてもエディタを使用できます

### 2.3 プロジェクトデータの自動保存

エディタはプロジェクトデータを自動的にブラウザのIndexedDBに保存します。

- シーンの変更から1秒後に自動保存が実行されます
- ブラウザを閉じても、次回起動時にプロジェクトが復元されます
- 異なるブラウザやデバイス間ではデータは共有されません

---

## 3. トップページ（TOP画面）

### 3.1 エディタメイン画面の構成

エディタを開くと、以下のレイアウトで構成されたメイン画面が表示されます。

```
┌──────────────────────────────────────────────────────────────────┐
│                        Menubar                                    │
│  [File] [Edit] [Add] [Render] [View] [Help]                      │
├────────────────┬─────────────────────────────────────────────────┤
│   Toolbar      │                                                  │
│ [移動][回転]   │                   Viewport                       │
│ [スケール]     │               (3Dシーンビュー)                   │
│                │                                                  │
├────────────────┤                                                  │
│                │                                          [View  │
│   Sidebar      │                                          Helper]│
│   ─────────    │                                                  │
│  Scene         │                                                  │
│  Project       ├─────────────────────────────────────────────────┤
│  Settings      │            Script Editor / Player               │
│                │                                                  │
└────────────────┴─────────────────────────────────────────────────┘
```

### 3.2 各エリアの役割

| エリア | 役割 |
|--------|------|
| **Menubar** | ファイル操作、編集、オブジェクト追加、レンダリング、表示設定、ヘルプへのアクセス |
| **Toolbar** | 変形ツール（移動/回転/スケール）の選択、スナップ設定 |
| **Viewport** | 3Dシーンのプレビューと編集。マウス操作でカメラ制御、オブジェクト選択・変形が可能 |
| **Sidebar** | シーン階層、オブジェクトプロパティ、マテリアル、プロジェクト設定の表示・編集 |
| **Script Editor** | JavaScriptスクリプトの編集（オブジェクトへの動作追加） |
| **Player** | シーンの再生プレビュー（スクリプト動作確認） |
| **View Helper** | 視点の素早い切り替え（右下に表示） |

### 3.3 基本的なマウス操作

| 操作 | 動作 |
|------|------|
| **左ドラッグ** | カメラの回転（オービット） |
| **中ドラッグ/右ドラッグ** | カメラのパン（平行移動） |
| **スクロール** | カメラのズーム |
| **左クリック** | オブジェクトの選択 |
| **ダブルクリック** | オブジェクトへのフォーカス |

---

## 4. 【STEP1】プロジェクト準備（新規作成・読み込み）

> **業務フローでの位置**: 3Dコンテンツ制作の開始時に、新規プロジェクトを作成するか、既存プロジェクトを読み込むステップです。

### 4.1 新規プロジェクトを作成する

**やるべきこと**: 空のプロジェクトまたはサンプルプロジェクトを新規作成する

**操作手順**:

1. メニューバーの「File」をクリックします
2. 「New」にマウスを合わせてサブメニューを表示します
3. 以下のいずれかを選択します：
   - 「Empty」: 空のプロジェクトを作成
   - 「Arkanoid」「Camera」「Particles」「Pong」「Shaders」: サンプルプロジェクトを読み込み
4. 確認ダイアログが表示されたら「OK」をクリックします

**注意点・Tips**:
- 新規作成を実行すると、現在のプロジェクトは破棄されます
- 重要なプロジェクトは事前に保存してください

### 4.2 プロジェクトを開く

**やるべきこと**: 以前に保存したプロジェクトファイル（.json）を読み込む

**操作手順**:

1. メニューバーの「File」をクリックします
2. 「Open」をクリックします
3. 確認ダイアログが表示されたら「OK」をクリックします
4. ファイル選択ダイアログが表示されます
5. 読み込みたいプロジェクトファイル（.json）を選択します
6. 「開く」をクリックします

**注意点・Tips**:
- プロジェクトファイルはJSON形式です
- 読み込みに失敗した場合、エラーメッセージが表示されます

### 4.3 プロジェクトを保存する

**やるべきこと**: 現在のプロジェクトをJSON形式で保存する

**操作手順**:

1. メニューバーの「File」をクリックします
2. 「Save」をクリックします
3. 「project.json」という名前でファイルがダウンロードされます

**注意点・Tips**:
- 保存されるファイル名は常に「project.json」です
- 必要に応じてファイル名を変更して管理してください
- 自動保存はブラウザ内のみなので、重要なプロジェクトはファイルとして保存することを推奨します

### 4.4 外部ファイルをインポートする

**やるべきこと**: 外部の3Dモデルファイルをシーンに読み込む

**操作手順**:

1. メニューバーの「File」をクリックします
2. 「Import」をクリックします
3. ファイル選択ダイアログが表示されます
4. インポートしたいファイルを選択します（複数選択可能）
5. 「開く」をクリックします

**対応フォーマット**:
- GLTF / GLB（推奨）
- FBX
- OBJ
- STL
- 3DS
- Collada (DAE)
- その他多数

**注意点・Tips**:
- ファイルをViewport領域に直接ドラッグ&ドロップしてもインポート可能です
- GLTFインポート時は、オプションダイアログが表示される場合があります

---

## 5. 【STEP2-3】3Dオブジェクト編集（追加・変形・マテリアル設定）

> **業務フローでの位置**: プロジェクト準備後、3Dオブジェクトを追加し、配置・編集するステップです。

### 5.1 オブジェクトを追加する

**やるべきこと**: シーンに3Dオブジェクト（メッシュ、ライト、カメラ）を追加する

**操作手順（メッシュの追加）**:

1. メニューバーの「Add」をクリックします
2. 「Mesh」にマウスを合わせてサブメニューを表示します
3. 追加したい形状を選択します：
   - Box（直方体）
   - Sphere（球体）
   - Cylinder（円柱）
   - Plane（平面）
   - Torus（ドーナツ型）
   - など16種類
4. 選択したオブジェクトがシーンの原点に追加されます

**操作手順（ライトの追加）**:

1. メニューバーの「Add」をクリックします
2. 「Light」にマウスを合わせてサブメニューを表示します
3. 追加したいライトを選択します：
   - Ambient（環境光）
   - Directional（平行光源）
   - Point（点光源）
   - Spot（スポットライト）
   - Hemisphere（半球光）
4. 選択したライトがシーンに追加されます

**操作手順（カメラの追加）**:

1. メニューバーの「Add」をクリックします
2. 「Camera」にマウスを合わせてサブメニューを表示します
3. 追加したいカメラを選択します：
   - Perspective（透視投影カメラ）
   - Orthographic（正射影カメラ）
4. 選択したカメラがシーンに追加されます

### 5.2 オブジェクトを選択する

**やるべきこと**: 編集対象のオブジェクトを選択する

**操作手順（Viewportでの選択）**:

1. Viewport内で、選択したいオブジェクトをクリックします
2. オブジェクトが選択され、選択ボックス（境界ボックス）が表示されます
3. 選択されたオブジェクトのプロパティがSidebarに表示されます

**操作手順（シーン階層での選択）**:

1. Sidebarの「Scene」タブをクリックします
2. 「Outliner」でシーン階層が表示されます
3. 選択したいオブジェクト名をクリックします

### 5.3 オブジェクトを変形する

**やるべきこと**: オブジェクトの位置、回転、スケールを変更する

**操作手順（ツールバーを使用）**:

1. オブジェクトを選択します
2. Toolbarで変形モードを選択します：
   - 「Translate」（移動）- 矢印アイコン
   - 「Rotate」（回転）- 円アイコン
   - 「Scale」（スケール）- 四角アイコン
3. Viewport内で表示されるギズモ（矢印、円、四角）をドラッグして変形します

**操作手順（Sidebarで数値入力）**:

1. オブジェクトを選択します
2. Sidebarの「Object」パネルを確認します
3. 以下のプロパティを直接編集します：
   - Position（位置）: X, Y, Z座標
   - Rotation（回転）: X, Y, Z軸の回転角度
   - Scale（スケール）: X, Y, Z軸のスケール値

**注意点・Tips**:
- Toolbarの「Snap」をオンにすると、グリッドにスナップして変形できます
- キーボードショートカット: W（移動）、E（回転）、R（スケール）

### 5.4 マテリアルを編集する

**やるべきこと**: オブジェクトの見た目（色、テクスチャ、質感）を設定する

**操作手順**:

1. オブジェクトを選択します
2. Sidebarの「Material」パネルを確認します
3. マテリアルタイプを選択します：
   - MeshBasicMaterial（基本）
   - MeshLambertMaterial（ランバート）
   - MeshPhongMaterial（フォン）
   - MeshStandardMaterial（PBR標準）- 推奨
   - MeshPhysicalMaterial（PBR物理）
4. プロパティを編集します：
   - Color（色）: カラーピッカーで選択
   - Map（テクスチャ）: 画像をドロップまたは選択
   - Roughness（粗さ）: 0〜1の値
   - Metalness（金属度）: 0〜1の値

**注意点・Tips**:
- MeshStandardMaterialまたはMeshPhysicalMaterialを使用すると、リアルな質感表現が可能です
- テクスチャ画像はViewportにドラッグ&ドロップで適用できます

### 5.5 ジオメトリパラメータを編集する

**やるべきこと**: オブジェクトの形状パラメータを変更する

**操作手順**:

1. オブジェクトを選択します
2. Sidebarの「Geometry」パネルを確認します
3. ジオメトリタイプに応じたパラメータを編集します：
   - Box: width, height, depth, segments
   - Sphere: radius, widthSegments, heightSegments
   - Cylinder: radiusTop, radiusBottom, height, segments
   - など

---

## 6. 【STEP3-4】シーン設定（背景・環境・フォグ）

> **業務フローでの位置**: オブジェクト編集後、シーン全体の見た目を調整するステップです。

### 6.1 背景を設定する

**やるべきこと**: シーンの背景色または背景画像を設定する

**操作手順**:

1. Sidebarの「Scene」タブをクリックします
2. 「Background」セクションを見つけます
3. 背景タイプを選択します：
   - Color: 単色背景
   - Texture: テクスチャ画像
   - Equirectangular: HDR環境マップ
4. 色やテクスチャを設定します

### 6.2 環境を設定する

**やるべきこと**: 環境マップを設定して、反射や照明に影響を与える

**操作手順**:

1. Sidebarの「Scene」タブをクリックします
2. 「Environment」セクションを見つけます
3. 環境タイプを選択します：
   - None: 環境なし
   - Background: 背景と同じ
   - Texture: 個別のテクスチャ
4. テクスチャを設定します（HDR形式推奨）

### 6.3 フォグを設定する

**やるべきこと**: 距離に応じた霧効果を追加する

**操作手順**:

1. Sidebarの「Scene」タブをクリックします
2. 「Fog」セクションを見つけます
3. フォグタイプを選択します：
   - None: フォグなし
   - Fog: 線形フォグ
   - FogExp2: 指数フォグ
4. パラメータを設定します：
   - Color: 霧の色
   - Near/Far（線形フォグ）: 開始/終了距離
   - Density（指数フォグ）: 密度

### 6.4 プレビューで確認する

**やるべきこと**: 設定した内容をプレビューで確認する

**操作手順（シェーディングモード切り替え）**:

1. Viewportの左上にある「ViewportControls」を確認します
2. シェーディングモードを選択します：
   - Solid: 標準表示
   - Wireframe: ワイヤーフレーム表示
   - Normals: 法線表示
   - Realistic: パストレーシング（高品質）

**操作手順（再生プレビュー）**:

1. Playerパネルの「再生」ボタンをクリックします
2. スクリプトが実行され、アニメーションが再生されます
3. 「停止」ボタンをクリックして編集モードに戻ります

---

## 7. 【STEP4-5】エクスポート・公開

> **業務フローでの位置**: シーン制作完了後、成果物を出力・公開するステップです。

### 7.1 3Dモデルをエクスポートする

**やるべきこと**: シーンまたは選択オブジェクトを3Dファイル形式でエクスポートする

**操作手順（GLTF/GLBエクスポート）** - 推奨:

1. メニューバーの「File」をクリックします
2. 「Export」にマウスを合わせてサブメニューを表示します
3. 「GLB」または「GLTF」を選択します：
   - GLB: バイナリ形式（ファイルサイズが小さい）
   - GLTF: JSON形式（編集可能）
4. ファイルがダウンロードされます（scene.glb または scene.gltf）

**対応エクスポートフォーマット**:

| フォーマット | 対象 | 説明 |
|------------|------|------|
| GLB | シーン全体 | glTF Binary形式（推奨） |
| GLTF | シーン全体 | glTF JSON形式 |
| OBJ | 選択オブジェクト | Wavefront OBJ形式 |
| STL | シーン全体 | 3Dプリント用 |
| STL (BINARY) | シーン全体 | バイナリSTL形式 |
| PLY | シーン全体 | ポイントクラウド形式 |
| PLY (BINARY) | シーン全体 | バイナリPLY形式 |
| DRC | 選択オブジェクト | Draco圧縮形式 |
| USDZ | シーン全体 | Apple AR用形式 |

### 7.2 静止画・動画をレンダリングする

**やるべきこと**: 高品質な静止画または動画を出力する

**操作手順（静止画レンダリング）**:

1. メニューバーの「Render」をクリックします
2. レンダリングオプションを選択します
3. 設定を確認して実行します
4. 画像ファイルがダウンロードされます

### 7.3 スタンドアロンアプリとして公開する

**やるべきこと**: エディタで作成したシーンを独立したWebアプリケーションとして出力する

**操作手順**:

1. メニューバーの「File」をクリックします
2. 「Export」サブメニューから「Publish」を選択します
3. アプリケーションファイルがダウンロードされます
4. ダウンロードしたファイルをWebサーバーにアップロードして公開します

**注意点・Tips**:
- エクスポートされたアプリは、HTMLファイルと関連アセットで構成されます
- WebサーバーでHTTPS配信することを推奨します

---

## 8. Examples（サンプル）機能

### 8.1 サンプルを検索する

Examples画面では、three.jsの様々なサンプルコードを閲覧できます。

**操作手順**:

1. Examples画面（examples/index.html）にアクセスします
2. 検索ボックスにキーワードを入力します
3. カテゴリでフィルタリングします：
   - WebGL（217件）
   - WebGL Postprocessing（26件）
   - WebGPU（194件）
   - WebXR（26件）
   - など

### 8.2 サンプルを閲覧する

**操作手順**:

1. サムネイルをクリックします
2. サンプルがiframeで表示されます
3. ソースコードを確認する場合は「View Source」をクリックします

---

## 9. Documentation（ドキュメント）機能

### 9.1 APIドキュメントを検索する

Documentation画面では、three.jsのAPIリファレンスを参照できます。

**操作手順**:

1. Documentation画面（docs/index.html）にアクセスします
2. 左側のナビゲーションツリーを展開します
3. または、検索ボックスでクラス名を検索します

### 9.2 インタラクティブデモを利用する

**操作手順**:

1. ドキュメント内のリンクからインタラクティブデモにアクセスします
   - Geometry Browser: ジオメトリのプレビュー
   - Material Browser: マテリアルのプレビュー
   - Bones Browser: スケルトンアニメーションのプレビュー
2. パラメータを変更してリアルタイムで結果を確認します

---

## 10. Manual（マニュアル）機能

### 10.1 マニュアルにアクセスする

Manual画面では、three.jsの学習用ガイドを参照できます。

**操作手順**:

1. Manual画面（manual/index.html）にアクセスします
2. 言語を選択します（日本語、英語、フランス語、ロシア語、韓国語、中国語）
3. チャプターを選択して学習します：
   - Fundamentals（基礎）
   - Techniques（テクニック）
   - Solutions（ソリューション）
   - Tips（Tips）

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】プロジェクトの準備 → 4章参照
    ↓
【STEP 2】3Dオブジェクトの追加と配置 → 5.1〜5.2参照
    ↓
【STEP 3】オブジェクトの編集 → 5.3〜5.5参照
    ↓
【STEP 4】シーン設定とプレビュー → 6章参照
    ↓
【STEP 5】エクスポートまたは公開 → 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【デザイナー】STEP1-2: プロジェクト作成とオブジェクト配置

3Dコンテンツ制作の開始時に、シーンの基本構造を構築します。

1. エディタにアクセスします
2. 「File」→「New」→「Empty」で新規プロジェクトを作成します
3. 「Add」→「Mesh」から基本形状を追加します
4. 「Add」→「Light」→「Directional」でライトを追加します
5. オブジェクトを選択してToolbarで配置を調整します

### 11.2 【デザイナー】STEP3: オブジェクトの編集

配置したオブジェクトの見た目を調整します。

1. オブジェクトを選択します
2. Sidebarの「Material」パネルでマテリアルを設定します
3. 「Geometry」パネルで形状パラメータを調整します
4. 必要に応じてテクスチャをドラッグ&ドロップで適用します

### 11.3 【デザイナー】STEP4: シーン設定とプレビュー

シーン全体の雰囲気を調整し、確認します。

1. Sidebarの「Scene」タブで背景を設定します
2. 環境マップを設定してライティングを改善します
3. ViewportControlsでシェーディングモードを切り替えて確認します
4. Playerで再生プレビューを行います

### 11.4 【開発者】STEP5: エクスポートと公開

完成したシーンを出力します。

1. 「File」→「Save」でプロジェクトを保存します
2. 「File」→「Export」→「GLB」でGLB形式でエクスポートします
3. 必要に応じて「Publish」でスタンドアロンアプリを出力します

---

## 12. よくある質問と対処法

### 12.1 ファイル操作に関するQ&A

**Q: プロジェクトを保存したはずなのに、次回起動時に復元されない**

A: 以下を確認してください：
- ブラウザのプライベートモードで使用していませんか？
- ブラウザのストレージをクリアしていませんか？
- 異なるブラウザやデバイスからアクセスしていませんか？

ブラウザ間でデータを共有するには、「File」→「Save」でJSONファイルとして明示的に保存し、「File」→「Open」で読み込んでください。

**Q: インポートしたモデルが表示されない**

A: 以下を確認してください：
- ファイル形式が対応しているか確認してください
- モデルが非常に大きい/小さい場合、カメラからの距離が適切でない可能性があります
- Viewportでスクロールしてズームアウトしてみてください

### 12.2 編集操作に関するQ&A

**Q: オブジェクトを削除する方法**

A: 以下の手順で削除できます：
1. オブジェクトを選択します
2. メニューバーの「Edit」→「Delete」をクリックします
3. または、キーボードの「Delete」キーを押します

**Q: 操作を元に戻す方法**

A: 以下の手順で元に戻せます：
1. メニューバーの「Edit」→「Undo」をクリックします
2. または、キーボードショートカット Ctrl+Z（Mac: Cmd+Z）を使用します

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| プロジェクトを開けませんでした | JSONファイルの形式が不正 | 有効なthree.jsプロジェクトファイルか確認してください |
| Meshが選択されていません | DRCエクスポート時にMesh以外が選択されている | Meshオブジェクトを選択してからエクスポートしてください |
| オブジェクトが選択されていません | OBJエクスポート時に何も選択されていない | エクスポートしたいオブジェクトを選択してください |

### 13.2 よくあるトラブルと解決方法

**トラブル: 画面が真っ暗で何も表示されない**

解決方法：
1. シーンにライトが追加されているか確認してください
2. 「Add」→「Light」→「Ambient」で環境光を追加してください
3. カメラの位置がオブジェクトから離れすぎていないか確認してください

**トラブル: 動作が重い、カクカクする**

解決方法：
1. シーン内のオブジェクト数を減らしてください
2. ジオメトリのセグメント数（分割数）を減らしてください
3. 不要なヘルパーを「View」メニューから非表示にしてください
4. パストレーサーモードを使用している場合は、通常のSolidモードに切り替えてください

**トラブル: テクスチャが表示されない**

解決方法：
1. 画像ファイルの形式がサポートされているか確認してください（PNG、JPG、WebP推奨）
2. 画像ファイルサイズが大きすぎないか確認してください
3. UV座標が正しく設定されているか確認してください

### 13.3 サポートへの連絡方法

three.jsはオープンソースプロジェクトです。問題が解決しない場合は、以下のリソースを活用してください：

- **公式ドキュメント**: https://threejs.org/docs/
- **GitHubリポジトリ**: https://github.com/mrdoob/three.js
- **Discord**: https://discord.gg/56GBJwAnUS
- **フォーラム**: https://discourse.threejs.org/

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-27 | 初版作成 |

---

*本マニュアルは、three.js Editorのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
