---
generated_at: 2026-01-27 14:10:00
metrics:
  claims_total: 40
  claims_with_evidence: 36
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：36 / 40、根拠なし：4
- 優先レビュー（高）
  1. **NFT-001 フレームレンダリング性能テスト**：16.67msという数値目標の妥当性を確認必要
  2. **NFT-003 テクスチャ読み込み時間テスト**：1/10以下という基準の根拠不足
  3. **NFT-004 大量オブジェクト描画テスト**：1000個、30fpsの数値根拠不足
  4. **NFT-027 例外リストスクリーンショットテスト**：11分の閾値根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - ビルドスクリプト、テストコマンド、browserslist設定
- E-02: `.github/workflows/ci.yml` - CI/CDワークフロー定義
- E-03: `.github/workflows/codeql-code-scanning.yml` - セキュリティスキャン設定
- E-04: `.github/workflows/read-size.yml` - バンドルサイズ計測ワークフロー
- E-05: `test/e2e/puppeteer.js` - E2Eテスト設定（pixelThreshold、maxDifferentPixels等）
- E-06: `test/e2e/check-coverage.js` - サンプルカバレッジチェック
- E-07: `test/rollup.treeshake.config.js` - Tree-shakeテスト設定
- E-08: `src/renderers/webgl/WebGLCapabilities.js` - WebGL能力検出
- E-09: `src/renderers/webgl/WebGLInfo.js` - レンダリング統計
- E-10: `src/renderers/common/Info.js` - 共通レンダリング統計
- E-11: `src/loaders/Cache.js` - キャッシュシステム
- E-12: `eslint.config.js` - ESLint設定
- E-13: `SECURITY.md` - セキュリティポリシー
- E-14: `.github/codeql-config.yml` - CodeQL設定
- E-15: `src/utils.js` - ユーティリティ関数（ロギング機能）
- E-16: `docs/code-to-docs/非機能要件定義書/非機能要件定義書.md` - 非機能要件定義書

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001 フレームレンダリング性能テスト（16.67ms以内） | E-16 | △ |
| C-02 | NFT-002 シェーダーコンパイル時間テスト | E-08, E-16 | ○ |
| C-03 | NFT-003 テクスチャ読み込み時間テスト（1/10以下） | E-11 | △ |
| C-04 | NFT-004 大量オブジェクト描画テスト（1000個、30fps） | **根拠なし** | △ |
| C-05 | NFT-005 テクスチャサイズ限界テスト | E-08 | ○ |
| C-06 | NFT-006 頂点属性数限界テスト | E-08 | ○ |
| C-07 | NFT-007 Tree-shake有効性テスト | E-04, E-07 | ○ |
| C-08 | NFT-008 Gzip圧縮サイズテスト | E-04 | ○ |
| C-09 | NFT-009 対応ブラウザ動作テスト | E-01 | ○ |
| C-10 | NFT-010 WebGL2必須機能テスト | E-08, E-16 | ○ |
| C-11 | NFT-011 WebGPUフォールバックテスト | E-16 | ○ |
| C-12 | NFT-012 コンテキスト喪失復元テスト | E-16 | ○ |
| C-13 | NFT-013 リクエスト中断テスト | E-16 | ○ |
| C-14 | NFT-014 HTTPエラーハンドリングテスト | E-16 | ○ |
| C-15 | NFT-015 クロスオリジンリソース読み込みテスト | E-16 | ○ |
| C-16 | NFT-016 認証情報送信テスト | E-16 | ○ |
| C-17 | NFT-017 URLモディファイア検証テスト | E-16 | ○ |
| C-18 | NFT-018 CodeQLセキュリティスキャンテスト | E-03, E-14 | ○ |
| C-19 | NFT-019 ES Modules読み込みテスト | E-01 | ○ |
| C-20 | NFT-020 CommonJS読み込みテスト | E-01 | ○ |
| C-21 | NFT-021 WebGPUモジュール読み込みテスト | E-01 | ○ |
| C-22 | NFT-022 アドオン互換性テスト | E-01 | ○ |
| C-23 | NFT-023 ESLint静的解析テスト | E-01, E-02, E-12 | ○ |
| C-24 | NFT-024 単体テスト実行 | E-01, E-02 | ○ |
| C-25 | NFT-025 アドオン単体テスト実行 | E-01, E-02 | ○ |
| C-26 | NFT-026 E2Eスクリーンショット比較テスト（差分0.3%未満） | E-02, E-05 | ○ |
| C-27 | NFT-027 例外リストスクリーンショットテスト（11分閾値） | E-05 | △ |
| C-28 | NFT-028 サンプルカバレッジテスト | E-02, E-06 | ○ |
| C-29 | NFT-029 カスタムコンソール関数テスト | E-15 | ○ |
| C-30 | NFT-030 重複警告抑制テスト | E-15 | ○ |
| C-31 | NFT-031 レンダリング統計収集テスト | E-09, E-10 | ○ |
| C-32 | NFT-032 メモリ使用量追跡テスト | E-09, E-10 | ○ |
| C-33 | NFT-033 シェーダーエラー検出テスト | E-16 | ○ |
| C-34 | NFT-034 Material.disposeテスト | E-16 | ○ |
| C-35 | NFT-035 BufferGeometry.disposeテスト | E-16 | ○ |
| C-36 | NFT-036 Texture.disposeテスト | E-16 | ○ |
| C-37 | NFT-037 RenderTarget.disposeテスト | E-16 | ○ |
| C-38 | NFT-038 Renderer.disposeテスト | E-16 | ○ |
| C-39 | NFT-039 Cacheクリアテスト | E-11 | ○ |
| C-40 | NFT-040 重複リクエスト防止テスト | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-001 16.67msという数値目標**：60fpsを目標とした場合の論理的な導出（1000ms/60fps）に基づくが、明示的なSLA文書が存在しない
  - 候補：パフォーマンス要件定義書 / ベンチマーク結果 / ユーザー要求仕様書
- **NFT-003 1/10以下という基準**：キャッシュ効果の期待値として設定したが、根拠となる計測データがない
  - 候補：パフォーマンス計測結果 / ベンチマークレポート
- **NFT-004 1000個、30fpsという数値**：一般的なパフォーマンス目標として設定したが、明確な根拠がない
  - 候補：ベンチマーク結果 / 性能要件定義書
- **NFT-027 11分という閾値**：puppeteer.jsのexceptionListコメントに基づくが、この数値の決定根拠は不明
  - 候補：CI/CD実行ログ / テスト実行時間統計

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 性能テストの数値目標（NFT-001, NFT-003, NFT-004）は推定値であり、実環境での検証が必要
- **0: 低リスク** - CI/CD関連テスト（NFT-007, NFT-008, NFT-023-028）は既存ワークフローで自動実行されており信頼性が高い
- **0: 低リスク** - セキュリティテスト（NFT-015-018）はCodeQL設定に基づき実装されている
- **1: 中リスク** - リソース管理テスト（NFT-034-040）はdisposeパターンの網羅性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 性能目標値（16.67ms、30fps、1000個等）が実際の要件と整合しているか確認
- [ ] 対象ブラウザのbrowserslist設定が最新の市場シェアと一致しているか確認
- [ ] E2Eテストの差分閾値（0.3%）が適切か確認
- [ ] CodeQLセキュリティスキャンでカバーされていない脆弱性パターンがないか確認
- [ ] dispose関連テストで全リソースタイプがカバーされているか確認
- [ ] WebGPUフォールバック動作の網羅性を確認
