---
generated_at: 2026-01-27 13:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 40
  claims_without_evidence: 5
confidence_derived: 0.89
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：40 / 45、根拠なし：5
- 優先レビュー（高）
  1. **フレームレンダリング目標値16.67ms**：60fps前提の推定値
  2. **同時描画オブジェクト数の制限**：具体的な上限値が不明
  3. **コンテキスト喪失からの復元処理**：復元ロジックの詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - バージョン情報、browserslist設定、ビルド設定
- E-02: `src/loaders/Cache.js` - キャッシュシステム実装
- E-03: `src/loaders/FileLoader.js` - ファイル読み込み、CORS対応、AbortController
- E-04: `src/loaders/Loader.js` - crossOrigin、withCredentials設定
- E-05: `src/loaders/LoadingManager.js` - リクエスト管理、abort機能
- E-06: `src/renderers/WebGLRenderer.js` - レンダラー設定、コンテキスト管理
- E-07: `src/renderers/common/Renderer.js` - 共通レンダラー基盤
- E-08: `src/renderers/webgl/WebGLCapabilities.js` - GPU制限値取得
- E-09: `src/renderers/common/Info.js` - レンダリング統計
- E-10: `src/utils.js` - ロギング機能、コンソール関数
- E-11: `src/nodes/core/NodeCache.js` - ノードキャッシュ
- E-12: `eslint.config.js` - コーディング規約
- E-13: `utils/build/rollup.config.js` - ビルド設定、ライセンスヘッダー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バージョン0.182.0 | E-01 | ○ |
| C-02 | WebGL/WebGPU対応 | E-01, E-06, E-07 | ○ |
| C-03 | フレームレンダリング16.67ms目標 | **根拠なし（推定値）** | △ |
| C-04 | シェーダーキャッシュ機能 | E-06 (WebGLShaderCache import) | ○ |
| C-05 | Cacheシステムによる読み込み高速化 | E-02, E-03 | ○ |
| C-06 | probeAsyncによる非同期GPU同期 | E-10 | ○ |
| C-07 | WebGLCapabilitiesによる制限値取得 | E-08 | ○ |
| C-08 | 最大テクスチャサイズ取得 | E-08 | ○ |
| C-09 | 最大キューブマップサイズ取得 | E-08 | ○ |
| C-10 | 最大頂点属性数取得 | E-08 | ○ |
| C-11 | MSAAデフォルト4サンプル | E-07 | ○ |
| C-12 | browserslist設定 | E-01 | ○ |
| C-13 | WebGL 1非サポート (r163以降) | E-06 | ○ |
| C-14 | WebGPUフォールバック機構 | E-07 | ○ |
| C-15 | コンテキスト喪失フラグ | E-06 | ○ |
| C-16 | コンテキスト復元可能 | **根拠不足** | △ |
| C-17 | AbortController対応 | E-03, E-05 | ○ |
| C-18 | HttpErrorクラス | E-03 | ○ |
| C-19 | crossOriginプロパティ | E-04 | ○ |
| C-20 | withCredentialsオプション | E-03, E-04 | ○ |
| C-21 | requestHeaderカスタマイズ | E-03, E-04 | ○ |
| C-22 | urlModifierコールバック | E-05 | ○ |
| C-23 | addHandlerによるローダー登録 | E-05 | ○ |
| C-24 | ES Modules対応 | E-01 | ○ |
| C-25 | CommonJS対応 | E-01, E-13 | ○ |
| C-26 | Tree Shaking対応 | E-01 | ○ |
| C-27 | 複数エントリーポイント | E-13 | ○ |
| C-28 | NodeLibraryによるノード登録 | E-07 | ○ |
| C-29 | ESLintによる静的解析 | E-01, E-12 | ○ |
| C-30 | JSDocによるドキュメント生成 | E-01 | ○ |
| C-31 | QUnitによる単体テスト | E-01 | ○ |
| C-32 | Puppeteerによるe2eテスト | E-01 | ○ |
| C-33 | ECMAScript 2018準拠 | E-12 | ○ |
| C-34 | シングルクォート使用規約 | E-12 | ○ |
| C-35 | prefer-const強制 | E-12 | ○ |
| C-36 | MITライセンス | E-01, E-13 | ○ |
| C-37 | カスタムコンソール関数 | E-10 | ○ |
| C-38 | warnOnce重複警告抑制 | E-10 | ○ |
| C-39 | Infoクラスメトリクス | E-09 | ○ |
| C-40 | autoResetフラグ | E-09 | ○ |
| C-41 | シェーダーエラーチェック設定 | E-06 | ○ |
| C-42 | Cacheデフォルト無効 | E-02 | ○ |
| C-43 | 同時描画オブジェクト制限の具体値 | **根拠なし（デバイス依存）** | △ |
| C-44 | disposeメソッド対応クラス一覧 | **一部未確認** | △ |
| C-45 | DataMapによる参照管理 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-03 フレームレンダリング目標値**
  - 60fps (16.67ms) は一般的な目標値として記載したが、three.js公式ドキュメントで明示されていない
  - 候補：公式ドキュメント / ベンチマーク資料 / パフォーマンスガイド

- **C-16 コンテキスト喪失からの復元**
  - `_isContextLost`フラグの存在は確認したが、復元処理の詳細未確認
  - 候補：WebGLRenderer.js全文 / webglcontextrestored イベントハンドラ

- **C-43 同時描画オブジェクト数**
  - デバイス依存で上限が変動するため具体的な数値を記載できない
  - 候補：各GPU/デバイスのベンチマーク

- **C-44 disposeメソッド対応クラス**
  - 主要クラスは確認済みだが、全クラスの網羅的確認は未実施
  - 候補：全ソースファイルのdisposeメソッド検索結果

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - browserslist設定、ライセンス情報
- **0: 低リスク** - キャッシュシステム実装詳細
- **0: 低リスク** - ロギング機能
- **1: 中リスク** - 性能目標値（60fps前提）は推定値のため、ユースケースによっては適切でない可能性
- **1: 中リスク** - WebGPUサポートは実験的機能
- **2: 高リスク** - コンテキスト喪失からの復元処理の詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] フレームレンダリング目標値（16.67ms）がプロジェクト要件に適合するか確認
- [ ] WebGL 1非サポート（r163以降）が利用環境で問題ないか確認
- [ ] WebGPUフォールバック機構が必要な場合、getFallback設定を確認
- [ ] コンテキスト喪失時の挙動について追加調査が必要か判断
- [ ] 対象デバイスでのGPU制限値（テクスチャサイズ等）を事前確認
- [ ] disposeメソッドの呼び出しがアプリケーションで適切に実装されているか確認
