# 非機能要件定義書

## 概要

本ドキュメントは、three.js (JavaScript 3D ライブラリ) バージョン 0.182.0 における非機能要件を定義するものです。three.js はブラウザ上で動作するクライアントサイドライブラリであり、WebGL/WebGPU を利用した3Dレンダリングを提供します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| フレームレンダリング | 16.67ms以内 | 60fpsを目標とした場合の1フレームあたりの処理時間 |
| シェーダーコンパイル | 初回のみ発生 | WebGLShaderCacheによりコンパイル済みシェーダーをキャッシュ |
| テクスチャ読み込み | ネットワーク依存 | Cacheシステムにより2回目以降の読み込みを高速化可能 |
| GPU同期操作 | ポーリング間隔依存 | probeAsync関数により非同期で同期待機を実行 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時描画オブジェクト数 | デバイス依存 | WebGLCapabilitiesにより最大テクスチャ数等を取得 |
| 最大テクスチャサイズ | デバイス依存 | gl.MAX_TEXTURE_SIZE により制限 |
| 最大キューブマップサイズ | デバイス依存 | gl.MAX_CUBE_MAP_TEXTURE_SIZE により制限 |
| 最大頂点属性数 | デバイス依存 | gl.MAX_VERTEX_ATTRIBS により制限 |
| MSAA サンプル数 | 最大デバイス依存 | デフォルト4サンプル (antialias=true時) |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 対応ブラウザ | 市場シェア1%以上、IE11/Opera Mini除外 | browserslist設定による |
| WebGL サポート | WebGL 2必須 | WebGL 1はr163以降非サポート |
| WebGPU サポート | オプション | フォールバック機構あり (getFallback) |
| コンテキスト喪失対応 | 復元可能 | WebGLRenderer内で_isContextLostフラグにより管理 |
| リクエスト中断 | AbortController対応 | FileLoader, LoadingManagerにて実装 |
| エラー処理 | コールバック/Promise | onErrorコールバック、HttpErrorクラス |

## セキュリティ要件

### CORS (Cross-Origin Resource Sharing)

- ローダークラスに `crossOrigin` プロパティを実装 (デフォルト: 'anonymous')
- 異なるドメインからのリソース読み込みに対応
- `withCredentials` オプションによる認証情報の送信制御
  - `credentials: 'include'` または `'same-origin'` を選択可能

### 認証・認可

- HTTP リクエストヘッダーのカスタマイズ機能 (`requestHeader` プロパティ)
- TLS クライアント証明書対応 (`withCredentials` オプション)

### 入力検証

- URLの解決処理における `urlModifier` コールバックによる検証機能
- ファイルタイプに応じたハンドラー登録機能 (`addHandler`)

## 拡張性要件

### モジュール構成

- ES Modules 対応 (`"type": "module"`)
- CommonJS 対応 (build/three.cjs)
- Tree Shaking 対応 (sideEffects設定により最適化)
- 複数エントリーポイント対応
  - three.module.js (標準WebGL)
  - three.webgpu.js (WebGPU対応)
  - three.tsl.js (Three.js Shading Language)
  - three.core.js (コアモジュール)

### プラグイン/アドオン機構

- examples/jsm ディレクトリにアドオンを配置
- NodeLibrary によるカスタムノード登録
- LoadingManager.addHandler によるカスタムローダー登録

### API拡張

- EventDispatcher による独自イベント発行
- カスタムシェーダーマテリアル対応 (ShaderMaterial, RawShaderMaterial)
- ノードベースマテリアルシステム (NodeMaterial)

## 保守性要件

### コード品質

- ESLint による静的解析 (eslint-config-mdcs ベース)
- JSDoc によるドキュメント生成
- 単体テスト (QUnit)
- E2Eテスト (Puppeteer)
- Tree-shakeテスト (rollup.treeshake.config.js)

### コーディング規約

- ECMAScript 2018 準拠
- シングルクォート使用
- prefer-const 強制
- 重複インポート禁止
- JSDoc型チェック

### バージョン管理

- Semantic Versioning (現在: 0.182.0)
- ライセンスヘッダー自動挿入 (MIT License, 2010-2026)
- SPDX License Identifier 対応

## 運用・監視要件

### ロギング

- カスタムコンソール関数設定 (`setConsoleFunction`)
- 3種類のログレベル: log, warn, error
- 重複警告抑制機能 (`warnOnce`)
- THREE. プレフィックス付きメッセージ出力

### レンダリング統計

- Info クラスによるメトリクス収集
  - フレームID
  - レンダーコール数
  - ドローコール数
  - 描画プリミティブ数 (三角形、点、線)
  - コンピュートコール数
  - GPU タイムスタンプ
  - メモリ使用量 (ジオメトリ数、テクスチャ数)
- 自動リセット機能 (autoReset)
- 手動リセット機能 (reset)

### デバッグ機能

- シェーダーエラーチェック (`debug.checkShaderErrors`)
- カスタムシェーダーエラーレポーティング (`debug.onShaderError`)
- THREE_DEVTOOLS インテグレーション

## キャッシュ設定

### ファイルキャッシュ

- `Cache` オブジェクトによるグローバルキャッシュ
- デフォルト無効 (`Cache.enabled = false`)
- `file:` プレフィックス付きキーで管理
- add/get/remove/clear メソッド提供

### シェーダーキャッシュ

- `WebGLShaderCache` によるシェーダープログラムキャッシュ
- コンパイル済みシェーダーの再利用

### ノードキャッシュ

- `NodeCache` クラスによるノードデータキャッシュ
- WeakMap ベースの参照管理
- 親キャッシュチェーン対応

### 重複リクエスト防止

- `loading` オブジェクトによる進行中リクエスト追跡
- 同一URLへの重複リクエストを統合

## リソース管理

### メモリ解放

- `dispose()` メソッドによる明示的なリソース解放
- 以下のオブジェクトで dispose 対応:
  - Material
  - BufferGeometry
  - Texture
  - RenderTarget
  - Renderer

### 自動クリーンアップ

- Info.dispose() による統計情報リセット
- DataMap による参照管理

## 備考

- 本ドキュメントはソースコード解析に基づいて作成されており、一部の数値目標は推定値です
- デバイス依存の制限値は実行時にWebGLCapabilitiesから取得されます
- WebGPU 対応は実験的機能として提供されています
