---
generated_at: 2026-01-20 15:40:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **ベースURL情報**：REST APIではないためN/A
  2. **一部メソッドの詳細パラメータ**：ソースコード全体を確認する必要あり
  3. **オンラインドキュメントの現在のURL有効性**：外部リソースのため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/README.md`
- E-02: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/TypeLibrary/CorType.odl`
- E-03: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System/CorArray.cls`
- E-04: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Collections/ArrayList.cls`
- E-05: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Text/StringBuilder.cls`
- E-06: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System/*.cls` (77ファイル)
- E-07: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Collections/*.cls` (40ファイル)
- E-08: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Security.Cryptography/*.cls` (76ファイル)
- E-09: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Text/*.cls` (43ファイル)
- E-10: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.IO/*.cls` (35ファイル)
- E-11: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Globalization/*.cls` (28ファイル)
- E-12: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Resources/*.cls` (30ファイル)
- E-13: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/System.Numerics/*.cls` (2ファイル)
- E-14: `/Users/tomokababa/Work/reverse-engineering/VBCorLib-master/Source/CorLib/Microsoft.Win32/*.cls`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET FrameworkのクラスをVB6/VBAで再実装したライブラリである | E-01 | ○ |
| C-02 | TypeLibraryのUUIDは1705040f-4494-4ab3-8a97-a9f84820636d、バージョンは4.0 | E-02 | ○ |
| C-03 | CorArrayクラスは配列操作ユーティリティを提供 | E-03 | ○ |
| C-04 | CorArrayにはExists, Find, FindIndex, BinarySearch等のメソッドがある | E-03 | ○ |
| C-05 | ArrayListは動的配列を提供し、IObject, ICollection, IEnumerable等を実装 | E-04 | ○ |
| C-06 | ArrayListにはAdd, AddRange, BinarySearch, Clear, Contains等のメソッドがある | E-04 | ○ |
| C-07 | StringBuilderは効率的な文字列構築を提供 | E-05 | ○ |
| C-08 | StringBuilderにはAppend, AppendChar, AppendFormat, AppendLine等のメソッドがある | E-05 | ○ |
| C-09 | System名前空間にはCorDateTime, TimeSpan, Version, Guid等のクラスがある | E-06 | ○ |
| C-10 | System.Collections名前空間にはHashtable, Queue, Stack, SortedList等がある | E-07 | ○ |
| C-11 | System.Security.Cryptography名前空間にはMD5, SHA1, SHA256, RSA, DES, Rijndael等がある | E-08 | ○ |
| C-12 | System.Text名前空間にはEncoding, UTF8Encoding, UTF7Encoding, UnicodeEncoding等がある | E-09 | ○ |
| C-13 | System.IO名前空間にはFile, Directory, Path, FileStream, MemoryStream等がある | E-10 | ○ |
| C-14 | System.Globalization名前空間にはCultureInfo, NumberFormatInfo, Calendar等がある | E-11 | ○ |
| C-15 | System.Resources名前空間にはResourceReader, ResourceWriter, ResourceManager等がある | E-12 | ○ |
| C-16 | System.Numerics名前空間にはBigIntegerがある | E-13 | ○ |
| C-17 | Microsoft.Win32名前空間にはRegistry, RegistryKeyがある | E-14 | ○ |
| C-18 | IObjectインターフェースはEquals, GetHashCode, ToStringを定義 | E-02, E-06 | ○ |
| C-19 | ICollectionインターフェースはコレクションの基本機能を定義 | E-07 | ○ |
| C-20 | IEnumerableインターフェースはFor Each文でのイテレーション機能を定義 | E-07 | ○ |
| C-21 | vbInvalidProcedureCall(5), vbOverflow(6), vbOutOfMemory(7)等のエラーコード定義 | E-02 | ○ |
| C-22 | CorDateTimeはYear, Month, Day, Hour, Minute, Second等のプロパティを持つ | E-06 | ○ |
| C-23 | TimeSpanはDays, Hours, Minutes, Seconds, TotalDays等のプロパティを持つ | E-06 | ○ |
| C-24 | HashtableはIObject, ICollection, IEnumerable, ICloneable, IDictionaryを実装 | E-07 | ○ |
| C-25 | QueueはFIFO方式でEnqueue, Dequeue, Peekメソッドを提供 | E-07 | ○ |
| C-26 | StackはLIFO方式でPush, Pop, Peekメソッドを提供 | E-07 | ○ |
| C-27 | EncodingクラスはGetBytes, GetString, GetChars等のメソッドを提供 | E-09 | ○ |
| C-28 | Fileクラスはファイル操作のスタティックメソッド（Exists, Copy, Delete等）を提供 | E-10 | ○ |
| C-29 | Directoryクラスはディレクトリ操作のスタティックメソッドを提供 | E-10 | ○ |
| C-30 | Pathクラスはパス文字列操作のスタティックメソッドを提供 | E-10 | ○ |
| C-31 | FileStreamはStreamを継承しCanRead, CanSeek, CanWrite等のプロパティを持つ | E-10 | ○ |
| C-32 | HashAlgorithmはComputeHash, TransformBlock, TransformFinalBlock等のメソッドを提供 | E-08 | ○ |
| C-33 | SymmetricAlgorithmはCreateEncryptor, CreateDecryptor, GenerateKey, GenerateIV等のメソッドを提供 | E-08 | ○ |
| C-34 | RSACryptoServiceProviderはEncrypt, Decrypt, SignData, VerifyData等のメソッドを提供 | E-08 | ○ |
| C-35 | BigIntegerは任意精度の整数演算（Add, Subtract, Multiply, Divide, ModPow等）を提供 | E-13 | ○ |
| C-36 | RegistryKeyはOpenSubKey, CreateSubKey, GetValue, SetValue等のメソッドを提供 | E-14 | ○ |
| C-37 | 例外クラス階層（Exception > SystemException > ArgumentException等）が存在 | E-06, E-10 | ○ |
| C-38 | ライセンスはMITライセンス | E-01 | ○ |
| C-39 | オンラインドキュメントURLは http://www.kellyethridge.com/vbcorlib/doc/CorLib.html | E-01 | ○ |
| C-40 | CorStringクラスにはFormat, Split, Join, Contains等のメソッドがある | E-06 | ○ |
| C-41 | SortedListはキーでソートされたキー/値ペアを提供 | E-07 | ○ |
| C-42 | BitArrayはビット配列を提供 | E-07 | ○ |
| C-43 | オンラインドキュメントURLの現在の有効性 | **根拠なし** | △ |
| C-44 | 一部メソッドの詳細なパラメータ仕様（デフォルト値等） | **根拠なし** | △ |
| C-45 | .NET Framework 2.0相当のAPI提供という記述 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-43: オンラインドキュメントURLの有効性**
  - README.mdに記載されているURLだが、2020年の情報であり現在のアクセス可否は未確認
  - 候補：ブラウザでの直接確認 / archive.orgでの確認

- **C-44: 一部メソッドの詳細なパラメータ仕様**
  - 全クラスファイルの完全な解析は行っていないため、一部メソッドのオプションパラメータやデフォルト値が不完全な可能性
  - 候補：各.clsファイルの詳細確認 / CHMヘルプファイルの参照

- **C-45: .NET Framework相当バージョン**
  - README.mdには「.NET framework」との記載があるが、具体的なバージョン（2.0等）の明示はない
  - 提供されている機能セットから2.0相当と推測
  - 候補：開発者への確認 / リリースノートの確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ライブラリの基本構造（名前空間、クラス一覧）
- **0: 低リスク** - 主要クラスの存在とインターフェース実装
- **0: 低リスク** - 主要メソッドの存在（ソースコードで確認済み）
- **1: 中リスク** - メソッドの詳細なパラメータ仕様（一部未確認）
- **1: 中リスク** - 外部リソース（ドキュメントURL）の有効性
- **0: 低リスク** - ライセンス情報（LICENSE, README.mdで確認）

## 6) レビュアーチェックリスト（最小）
- [ ] API一覧の各クラスが実際のソースコードに存在するか確認
- [ ] 主要メソッドの引数・戻り値がソースコードと一致するか確認
- [ ] オンラインドキュメントURL（http://www.kellyethridge.com/vbcorlib/doc/CorLib.html）へのアクセス可否確認
- [ ] 使用例コードが実際に動作するか確認
- [ ] TypeLibraryのUUID/バージョンがCorType.odlと一致するか確認
- [ ] 例外クラス階層がソースコードの実装と一致するか確認
- [ ] System.Security.Cryptography配下の暗号化アルゴリズム一覧の網羅性確認
