# VBCorLib

## 概要

VBCorLibは、.NET Frameworkの多くのクラスをVisual Basic 6で実装したライブラリです。VBCorLib内のクラスは.NETの対応クラスとほぼ同じように使用できるため、.NETアプリケーションとVB6間でのデータ共有が容易になります。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| コレクション | ArrayList、Stack、Queue、Hashtable、SortedList、BitArrayなど多数のコレクション型を提供 |
| 暗号化（対称） | Rijndael（AES）、DES、TripleDES、RC2アルゴリズムを実装 |
| 暗号化（非対称） | RSA、DSA暗号化およびデジタル署名・検証機能を提供 |
| ハッシュアルゴリズム | SHA-1、SHA-256、SHA-384、SHA-512、MD5、RIPEMD-160を実装 |
| HMAC認証 | HMACSHA1、HMACSHA256、HMACSHA384、HMACSHA512、HMACMD5、HMACRIPEMD160、MACTripleDESを実装 |
| テキストエンコーディング | UTF-8、UTF-7、UTF-16、UTF-32、ASCIIおよびWindows対応エンコーディングに対応 |
| ファイル/IO操作 | FileStream、MemoryStream、StreamReader、StreamWriter、BinaryReader、BinaryWriterなどを提供 |
| 文字列操作 | StringBuilder、CorString（文字列操作ユーティリティ）を提供 |
| 日付/時刻操作 | CorDateTime、TimeSpan、各種カレンダー（GregorianCalendar、JulianCalendar、HebrewCalendar等）を提供 |
| グローバリゼーション | CultureInfo、NumberFormatInfo、DateTimeFormatInfoによる国際化対応 |
| 大きな数値 | BigInteger（任意精度整数）、Int64（64ビット符号付き整数）を提供 |
| コンソール | コンソールウィンドウへの簡単なアクセスを提供 |
| レジストリ操作 | RegistryKey、Registryクラスによるレジストリ操作を提供 |
| リソース管理 | ResourceReader、ResourceWriter、ResourceManagerによるリソース操作を提供 |
| メモリマップドファイル | MemoryMappedFile、MemoryMappedViewAccessorを提供（2GB超のファイル対応） |

## 技術スタック

### コア

- 言語: Visual Basic 6（VB6）
- ターゲット: ActiveX DLL（OLE DLL）
- 出力: VBCorLib3.dll

### 主要ライブラリ

- OLE Automation (stdole2.tlb)
- Visual Basic 6 Virtual Machine Type Library (vbvm6lib.tlb)
- VBCorLib 3.0 Type Library (CorType.tlb)

## ディレクトリ構成

```
VBCorLib-master/
├── Source/                          # メインソースコード
│   ├── CorLib/                      # コアライブラリ
│   │   ├── System/                  # 基本システムクラス（例外、配列、日付等）
│   │   ├── System.Collections/      # コレクションクラス
│   │   ├── System.Globalization/    # 国際化関連クラス
│   │   ├── System.IO/               # ファイル・ストリーム操作
│   │   ├── System.Text/             # テキストエンコーディング
│   │   ├── System.Security.Cryptography/ # 暗号化関連
│   │   ├── System.Numerics/         # BigInteger等の数値型
│   │   ├── System.Resources/        # リソース管理
│   │   ├── System.Threading/        # スレッド・タイマー
│   │   ├── Microsoft.Win32/         # Win32レジストリ操作
│   │   ├── Microsoft.Win32.SafeHandles/ # セーフハンドル
│   │   └── Cor/                     # ヘルパー関数
│   ├── Tests/                       # ユニットテスト
│   └── Fakes/                       # テスト用モックオブジェクト
├── Examples/                        # サンプルプロジェクト
│   ├── Console Example/             # コンソール出力サンプル
│   ├── Cryptography/                # 暗号化サンプル
│   ├── IO Examples/                 # ファイル操作サンプル
│   ├── Misc/                        # その他のサンプル
│   ├── NumberFormatting/            # 数値フォーマットサンプル
│   └── Registry/                    # レジストリ操作サンプル
├── TypeLibrary/                     # タイプライブラリファイル
├── Install/                         # インストーラスクリプト
├── Template/                        # テンプレートファイル
├── LICENSE                          # MIT License
└── README.md                        # プロジェクト説明（オリジナル）
```

## セットアップ

### 必要条件

- Windows OS
- Visual Basic 6（VB6）開発環境
- VB6 IDE（ソースコードの編集・コンパイル用）

### インストール手順

1. リポジトリをクローンまたはダウンロード
2. `Source/CorLib/CorLib.vbp`をVB6 IDEで開く
3. プロジェクトをコンパイルしてDLLを生成
4. 生成されたDLLをWindowsに登録（regsvr32使用）

### Git設定（開発者向け）

VB6 IDEが要求するWindows改行コードを正しく扱うため、以下の設定が必要です：

```shell
git config --global core.autocrlf false
```

## 開発

### プロジェクト構成

- `Source/CorLib/CorLib.vbp` - メインライブラリプロジェクト
- `Source/CorLib/CorLib.Build.vbp` - ビルド用プロジェクト
- `Source/Tests/CorLib.Tests.vbp` - テストプロジェクト
- `Source/Fakes/Fakes.vbp` - テスト用フェイクオブジェクト

### ビルド

1. VB6 IDEで`Source/CorLib/CorLib.vbp`を開く
2. メニューから「ファイル」→「xxx.dllの作成」を選択
3. 出力先は`Binaries/Compiled`ディレクトリ

### テスト

1. VB6 IDEで`Source/Tests/CorLib.Tests.vbp`を開く
2. テストプロジェクトを実行

### ドキュメント

- オンラインドキュメント: http://www.kellyethridge.com/vbcorlib/doc/CorLib.html
- オフラインドキュメント: http://www.kellyethridge.com/vbcorlib/doc/CorLib.chm
- CHMファイル: `Source/CorLib/CorLib.chm`に同梱

## ライセンス

MIT License

Copyright (c) 2017 Kelly Ethridge
