---
generated_at: 2026-01-20 16:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **ドキュメントURL有効性**：外部URLの現在のアクセス可否は未検証

## 2) 参照した情報（Evidence一覧）

- E-01: `/README.md` - プロジェクトルートのオリジナルREADME
- E-02: `/LICENSE` - MITライセンスファイル
- E-03: `/Source/CorLib/README.TXT` - バージョン履歴・変更ログ
- E-04: `/Source/CorLib/CorLib.vbp` - メインプロジェクトファイル
- E-05: `/Source/CorLib/` - ソースコードディレクトリ構造
- E-06: `/Source/Tests/CorLib.Tests.vbp` - テストプロジェクトファイル
- E-07: `/Source/Fakes/Fakes.vbp` - フェイクプロジェクトファイル
- E-08: `/Examples/` - サンプルプロジェクト群
- E-09: `/TypeLibrary/` - タイプライブラリディレクトリ
- E-10: `/Install/` - インストールスクリプトディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VBCorLibは.NET Frameworkの多くのクラスをVB6で実装している | E-01, E-03 | ○ |
| C-02 | コレクション型としてArrayList、Stack、Queue、Hashtable等を提供 | E-01, E-04 | ○ |
| C-03 | Rijndael、DES、TripleDES、RC2暗号化アルゴリズムを実装 | E-01, E-03 | ○ |
| C-04 | RSA、DSA非対称暗号化を提供 | E-01, E-03 | ○ |
| C-05 | SHA-1、SHA-256、SHA-384、SHA-512、MD5、RIPEMD-160ハッシュを実装 | E-01, E-03 | ○ |
| C-06 | HMAC認証コード機能を提供 | E-03, E-04 | ○ |
| C-07 | UTF-8、UTF-7、UTF-16、UTF-32エンコーディングに対応 | E-01, E-03, E-04 | ○ |
| C-08 | FileStream、MemoryStream等のIO操作クラスを提供 | E-04 | ○ |
| C-09 | StringBuilder、CorStringによる文字列操作を提供 | E-04 | ○ |
| C-10 | CorDateTime、TimeSpan、各種カレンダーを提供 | E-04 | ○ |
| C-11 | BigIntegerによる任意精度整数演算を提供 | E-01, E-03 | ○ |
| C-12 | コンソールウィンドウアクセス機能を提供 | E-01, E-04 | ○ |
| C-13 | 2GB超のファイルを扱える | E-01 | ○ |
| C-14 | 使用言語はVisual Basic 6 | E-04 | ○ |
| C-15 | 出力形式はActiveX DLL (OLE DLL) | E-04 | ○ |
| C-16 | 出力ファイル名はVBCorLib3.dll | E-04 | ○ |
| C-17 | ディレクトリ構成（Source/CorLib等） | E-05 | ○ |
| C-18 | テストプロジェクトの存在 | E-06 | ○ |
| C-19 | フェイクプロジェクトの存在 | E-07 | ○ |
| C-20 | サンプルプロジェクトの構成 | E-08 | ○ |
| C-21 | タイプライブラリの存在 | E-09 | ○ |
| C-22 | インストールスクリプトの存在 | E-10 | ○ |
| C-23 | MITライセンス、著作権者Kelly Ethridge | E-02 | ○ |
| C-24 | git core.autocrlf false設定が必要 | E-01 | ○ |
| C-25 | オンライン/オフラインドキュメントURLが有効 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- ドキュメントURL（http://www.kellyethridge.com/vbcorlib/）の現在のアクセス可否は実際のWeb確認が必要
  - 候補：Wayback Machine / 直接アクセス確認 / プロジェクトメンテナーへの確認

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 外部URLの有効性のみが未確認であり、プロジェクトの技術的記述は全てソースコードから確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] ドキュメントURL（http://www.kellyethridge.com/vbcorlib/doc/CorLib.html）へのアクセス確認
- [ ] 各機能カテゴリの説明がプロジェクトの実態と一致しているか確認
- [ ] ディレクトリ構成図が実際のプロジェクト構造と一致しているか確認
- [ ] セットアップ手順が実際のビルドプロセスと一致しているか確認
